/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rest.web.commons;

import cn.hutool.core.io.FileUtil;
import com.bcxin.Infrastructures.TenantConfigProperty;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

public interface FileProcessor {
    public String save(MultipartFile var1);

    @Component
    public static class FileProcessorImpl
    implements FileProcessor {
        private final TenantConfigProperty configProperty;

        public FileProcessorImpl(TenantConfigProperty configProperty) {
            this.configProperty = configProperty;
        }

        @Override
        public String save(MultipartFile file) {
            String relativePath = String.format("/uploads/%s/%s", UUID.randomUUID(), file.getOriginalFilename());
            String destFileName = String.format("%s/%s", this.configProperty.getUpload().getPath(), relativePath);
            File destFile = new File(destFileName);
            FileUtil.mkdir((File)destFile.getParentFile());
            try {
                destFile.createNewFile();
                file.transferTo(destFile);
            }
            catch (IOException e) {
                throw new BadTenantException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
            }
            return relativePath;
        }
    }
}

