package com.bcxin.identify.startup;

import cn.wildfirechat.sdk.AdminConfig;
import com.bcxin.identify.business.domain.SysConfig;
import com.bcxin.identify.business.service.SysConfigService;
import com.bcxin.identify.util.sys.ConfigUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * <b> 初始化配置 </b>
 * @author ZXF
 * @create 2021/01/29 0029 16:25
 * @version
 * @注意事项 </b>
 */
@Component
public class InitConfig {

	@Autowired
	private SysConfigService configService;

	@Value("${ye-huo.im-server.admin-url}")
	private String imServerAdminUrl;

	@Value("${ye-huo.im-server.secret}")
	private String imServerSecret;

	/**
	 *
	 * <b>Function </b> 初始化环境，定位当前系统的环境
	 *
	 * @author LuoPeng
	 * @date 2016年12月20日 下午8:52:24
	 */
	@PostConstruct
	private void initConfig(){
		List<SysConfig> configList = configService.systemConfigList();
		for (SysConfig config :configList) {
			ConfigUtil.putValue(config.getSysKey(),config.getSysValue());
		}
		//野火初始化
		AdminConfig.initAdmin(imServerAdminUrl, imServerSecret);
	}
	
}