package com.bcxin.identify.business.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.bcxin.identify.business.dao.ImRoammsgTempMapper;
import com.bcxin.identify.business.domain.ImRoammsgTemp;
import com.bcxin.identify.business.domain.dto.ImRoammsgDTO;
import com.bcxin.identify.util.DateUtil;
import com.bcxin.identify.util.PageInfoUtils;
import com.bcxin.identify.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;


@Service
@Transactional
@Slf4j
public class ImRoammsgTempService {
	
	@Autowired
	private ImRoammsgTempMapper imRoammsgTempMapper;
	

	public int batchInsert(List<ImRoammsgTemp> list){
		return imRoammsgTempMapper.batchInsertImRoammsgTemp(list);
	}

	public int deleteByExpire(){
		return imRoammsgTempMapper.deleteByExpire(DateUtil.getSecondTimestamp(new Date()));
	}

	public Result findImRoammsgTempByPcNo(String fromAccount, String toAccount, Integer pcNo, String keyword, Integer pageSize, Integer pageNumber){
		ImRoammsgDTO dto = new ImRoammsgDTO(fromAccount, toAccount, pcNo, keyword, pageSize, pageNumber);
		PageHelper.startPage(dto.getPageNumber(), dto.getPageSize());
		List<ImRoammsgTemp> list = imRoammsgTempMapper.findImRoammsgTempByPcNo(dto);
		PageInfoUtils pg = new PageInfoUtils(list);
		String ret = loopJointASC(list,list.size());
		pg.setData(JSON.parseArray("[" + ret + "]"));
		JSONObject json = new JSONObject();
		json.put("pcNo",pcNo);
		json.put("keyword",keyword);
		pg.setOther(json);
		return Result.success(Result.SUCCESS_MSG,pg);
	}

	public static String loopJointASC(List<ImRoammsgTemp> list,int size ) {
		if(list.size()<=0) return "";
		if(size==1) return list.get(list.size()-1).getContent();
		String joinStr = ",";
		String name = list.get(list.size()-size).getContent();
		size--;//下标值和递归次数减少1
		String loopJoint = loopJointASC(list, size);
		return name+joinStr+loopJoint;
	}
}
