package com.bcxin.identify.business.domain.ysp;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <b> 视频调度记录表 </b>
 * @author ZXF
 * @create 2020/06/19 0019 16:27
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("com_video_room")
public class ComVideoRoom extends Model<PerVideoRoom> {

	private static final long serialVersionUID = 1L;

	/**
	 * 记录ID
	 */
	@TableId(type = IdType.ID_WORKER)
	private Long comVideoRoomId;

	/**
	 * 企业ID
	 */
	private String comId;

	/**
	 * 房间号
	 */
	private String roomNo;

	/**
	 * 视频开始日期
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date startTime;

	/**
	 * 视频结束日期（指最后一个人离开房间的时间）
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date endTime;

	/**
	 * 调度者名称
	 */
	private String yardmanName;

	/**
	 * 调度类型 1:视频调度；2：视频上拉
	 */
	private String yardmanType;

	/**
	 * 调度任务名称
	 */
	private String yardmanTaskName;

	/**
	 * 调度任务说明
	 */
	private String yardmanTaskExplain;

	/**
	 * 调度人员
	 */
	private List<Map<String,String>> pList;

	/**
	 * 创建时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createOn;

	/**
	 * 修改时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date updateOn;

	private Integer pageSize;// 每页条数

	private Integer pageNumber;// 第几页

	@JsonIgnore
	public Integer getPageSize() {
		return pageSize;
	}
	@JsonIgnore
	public Integer getPageNumber() {
		return pageNumber;
	}
	@Override
	protected Serializable pkVal() {
		return this.comVideoRoomId;
	}
}
