package com.bcxin.identify.business.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <b> 猎鹰轨迹区域配置表 </b>
 * @author ZXF
 * @create 2021/03/22 0022 10:08
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("ly_trajectory")
public class LYTrajectory extends Model<LYTrajectory> {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@TableId(type = IdType.ID_WORKER)
	private Long lyTrajectoryId;

	/**
	 * 猎鹰应用key
	 */
	private String tKey;

	/**
	 * 应用key下属sid
	 */
	private String serviceId;

	/**
	 * 应用key下属sid的name
	 */
	private String name;

	/**
	 * 省编码
	 */
	private String province;

	/**
	 * 最大终端数
	 */
	private int maxTerminalNum;

	/**
	 * 终端是否已满（0/1）
	 */
	private int isFull;

	/**
	 * 顺序
	 */
	private int seq;

	/**
	 * 创建时间
	 */
	private Date createOn;

	/**
	 * 修改时间
	 */
	private Date updateOn;

	@Override
	protected Serializable pkVal() {
		return this.lyTrajectoryId;
	}

}
