package com.bcxin.identify.api.tencent.dto.im;


/**
 * <b> IM建群 </b>
 * @author ZXF
 * @create 2019/06/20 0020 15:36
 * @version
 * @注意事项 </b>
 */
public class ImCreateGroup {

	/**
	 * 群主 ID，自动添加到群成员中。如果不填，群没有群主
	 */
	private String Owner_Account;

	/**
	 * 群组形态，包括 Public（公开群），Private（私密群），ChatRoom（聊天室），AVChatRoom（音视频聊天室），BChatRoom（在线成员广播大群）
	 * 必填
	 */
	private String Type;

	/**
	 * 为了使得群组 ID 更加简单，便于记忆传播，腾讯云支持 App 在通过 REST API 创建群组时 自定义群组 ID
	 */
	private String GroupId;

	/**
	 * 群名称，最长30字节
	 * 必填
	 */
	private String Name;

	/**
	 * 群简介，最长240字节
	 */
	private String Introduction;

	/**
	 * 群公告，最长300字节
	 */
	private String Notification;

	/**
	 * 群头像 URL，最长100字节
	 */
	private String FaceUrl;

	/**
	 * 最大群成员数量，缺省时的默认值：私有群是200，公开群是2000，聊天室是10000，音视频聊天室和在线成员广播大群无限制
	 */
	private String MaxMemberCount;

	/**
	 * 申请加群处理方式。包含 FreeAccess（自由加入），NeedPermission（需要验证），DisableApply（禁止加群），不填默认为 NeedPermission（需要验证）
	 */
	private String ApplyJoinOption;

	/**
	 * 群组维度的自定义字段，默认情况是没有的，需要开通
	 */
	private String AppDefinedData;

	/**
	 * 初始群成员列表，最多500个
	 * 页面传手机号逗号隔开
	 * 后台转成一下格式
	 * "MemberList": [ // 初始群成员列表，最多500个（选填）
	 *	 {
	 *		"Member_Account": "bob", // 成员（必填）
	 *		"Role": "Admin" // 赋予该成员的身份，目前备选项只有 Admin（选填）
	 *	 },
	 *	 {
	 *		"Member_Account": "peter"
	 *	 }
	 *	]
	 */
	private Object[] MemberList;

	private String Members;

	/**
	 * 群成员维度的自定义字段，默认情况是没有的，需要开通
	 */
	private String AppMemberDefinedData;

	public String getOwner_Account() {
		return Owner_Account;
	}

	public void setOwner_Account(String owner_Account) {
		Owner_Account = owner_Account;
	}

	public String getType() {
		return Type;
	}

	public void setType(String type) {
		Type = type;
	}

	public String getGroupId() {
		return GroupId;
	}

	public void setGroupId(String groupId) {
		GroupId = groupId;
	}

	public String getName() {
		return Name;
	}

	public void setName(String name) {
		Name = name;
	}

	public String getIntroduction() {
		return Introduction;
	}

	public void setIntroduction(String introduction) {
		Introduction = introduction;
	}

	public String getNotification() {
		return Notification;
	}

	public void setNotification(String notification) {
		Notification = notification;
	}

	public String getFaceUrl() {
		return FaceUrl;
	}

	public void setFaceUrl(String faceUrl) {
		FaceUrl = faceUrl;
	}

	public String getMaxMemberCount() {
		return MaxMemberCount;
	}

	public void setMaxMemberCount(String maxMemberCount) {
		MaxMemberCount = maxMemberCount;
	}

	public String getApplyJoinOption() {
		return ApplyJoinOption;
	}

	public void setApplyJoinOption(String applyJoinOption) {
		ApplyJoinOption = applyJoinOption;
	}

	public String getAppDefinedData() {
		return AppDefinedData;
	}

	public void setAppDefinedData(String appDefinedData) {
		AppDefinedData = appDefinedData;
	}

	public String getAppMemberDefinedData() {
		return AppMemberDefinedData;
	}

	public void setAppMemberDefinedData(String appMemberDefinedData) {
		AppMemberDefinedData = appMemberDefinedData;
	}

	public Object[] getMemberList() {
		return MemberList;
	}

	public void setMemberList(Object[] memberList) {
		MemberList = memberList;
	}

	public String getMembers() {
		return Members;
	}

	public void setMembers(String members) {
		Members = members;
	}
}
