package com.bcxin.identify.api;

import com.bcxin.identify.business.service.ImRoammsgTempService;
import com.bcxin.identify.business.service.LYTrajectoryService;
import com.bcxin.identify.startup.CacheService;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 定时器
 *
 * @author zxf
 * @create 2019-10-11 16:40
 */
@Component
@EnableScheduling
public class Scheduler {

    @Resource
    private CacheService cacheService;
    @Resource
    private LYTrajectoryService lYTrajectoryService;
    @Resource
    private ImRoammsgTempService imRoammsgTempService;

    /**
     * <b> 重置缓存 </b>
     * @author ZXF
     * @create 2020/05/28 0028 15:02
     * @version
     * @注意事项 </b>
     */
    @Scheduled(cron = "0 0 5 * * ?") // 每天早上2点
    public void delComResource(){
        cacheService.deleteRedisByKey("GETUI_TOKEN");
        cacheService.deleteRedisByKey("TC_SIGN_");
        cacheService.deleteRedisByKey("TC_YSP_SIGN_");
    }

    /**
     * <b> 每10分钟检测一次轨迹设备是否达到上限进行预警 </b>
     * @author ZXF
     * @create 2021/07/22 0022 17:39
     * @version
     * @注意事项 </b>
     */
    @Scheduled(cron = "0 */10 * * * ?") // 每10分钟
    public void fullWarning(){
        lYTrajectoryService.fullWarning();
    }

    @Scheduled(cron = "0 */15 * * * ?") // 每15分钟
    public void deleteByExpire(){
        imRoammsgTempService.deleteByExpire();
    }
}
