/*
 * Decompiled with CFR 0.152.
 */
package ikidou.reflect.typeimpl;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;

public class WildcardTypeImpl
implements WildcardType {
    private final Class[] upper;
    private final Class[] lower;

    public WildcardTypeImpl(Class[] lower, Class[] upper) {
        this.lower = lower != null ? lower : new Class[]{};
        this.upper = upper != null ? upper : new Class[]{};
        this.checkArgs();
    }

    private void checkArgs() {
        if (this.lower.length == 0 && this.upper.length == 0) {
            throw new IllegalArgumentException("lower or upper can't be null");
        }
        this.checkArgs(this.lower);
        this.checkArgs(this.upper);
    }

    private void checkArgs(Class[] args) {
        for (int i = 1; i < args.length; ++i) {
            Class clazz = args[i];
            if (clazz.isInterface()) continue;
            throw new IllegalArgumentException(clazz.getName() + " not a interface!");
        }
    }

    @Override
    public Type[] getUpperBounds() {
        return this.upper;
    }

    @Override
    public Type[] getLowerBounds() {
        return this.lower;
    }

    public String toString() {
        if (this.upper.length > 0) {
            if (this.upper[0] == Object.class) {
                return "?";
            }
            return this.getTypeString("? extends ", this.upper);
        }
        return this.getTypeString("? super ", this.lower);
    }

    private String getTypeString(String prefix, Class[] type) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        for (int i = 0; i < type.length; ++i) {
            if (i != 0) {
                sb.append(" & ");
            }
            sb.append(type[i].getName());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardTypeImpl that = (WildcardTypeImpl)o;
        return Arrays.equals(this.upper, that.upper) && Arrays.equals(this.lower, that.lower);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.upper);
        result = 31 * result + Arrays.hashCode(this.lower);
        return result;
    }
}

