/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MediaMessageContent;
import java.util.Base64;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class VideoMessageContent
extends MediaMessageContent {
    private byte[] thumbnailBytes;
    private long duration;

    public VideoMessageContent setThumbnailBytes(byte[] thumbnailBytes) {
        this.thumbnailBytes = thumbnailBytes;
        return this;
    }

    public byte[] getThumbnailBytes() {
        return this.thumbnailBytes;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public int getContentType() {
        return 6;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setSearchableContent("[\u89c6\u9891]");
        payload.setBase64edData(Base64.getEncoder().encodeToString(this.thumbnailBytes));
        JSONObject objWrite = new JSONObject();
        objWrite.put((Object)"d", (Object)this.duration);
        objWrite.put((Object)"duration", (Object)this.duration);
        payload.setContent(objWrite.toJSONString());
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.thumbnailBytes = Base64.getDecoder().decode(payload.getBase64edData());
        try {
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(payload.getContent());
            this.duration = jsonObject.containsKey((Object)"d") ? ((Long)jsonObject.get((Object)"d")).longValue() : ((Long)jsonObject.get((Object)"duration")).longValue();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int getMediaType() {
        return 3;
    }
}

