/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MultiCallOngoingMessageContent
extends MessageContent {
    private String callId;
    private String initiator;
    private boolean audioOnly;
    private List<String> targets;

    public MultiCallOngoingMessageContent() {
    }

    public MultiCallOngoingMessageContent(String callId, String initiator, boolean audioOnly, List<String> targets) {
        this.callId = callId;
        this.initiator = initiator;
        this.audioOnly = audioOnly;
        this.targets = targets;
    }

    @Override
    public int getContentType() {
        return 416;
    }

    @Override
    public int getPersistFlag() {
        return 4;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setContent(this.callId);
        JSONObject object = new JSONObject();
        object.put((Object)"initiator", (Object)this.initiator);
        JSONArray arr = new JSONArray();
        for (int i = 0; i < this.targets.size(); ++i) {
            arr.add(i, (Object)this.targets.get(i));
        }
        object.put((Object)"targets", (Object)arr);
        object.put((Object)"audioOnly", (Object)(this.audioOnly ? 1 : 0));
        payload.setBase64edData(Base64.getEncoder().encodeToString(object.toString().getBytes()));
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.callId = payload.getContent();
        try {
            JSONObject object = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(payload.getBase64edData())));
            this.initiator = (String)object.get((Object)"initiator");
            this.targets = new ArrayList<String>();
            JSONArray array = (JSONArray)object.get((Object)"targets");
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    this.targets.add((String)array.get(i));
                }
            }
            this.audioOnly = (Integer)object.get((Object)"audioOnly") == 1;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public boolean isAudioOnly() {
        return this.audioOnly;
    }

    public void setAudioOnly(boolean audioOnly) {
        this.audioOnly = audioOnly;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(List<String> targets) {
        this.targets = targets;
    }
}

