/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.LinkMessageContent;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ArticlesMessageContent
extends MessageContent {
    public Article topArticle;
    public ArrayList<Article> subArticles;

    @Override
    public int getContentType() {
        return 13;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setSearchableContent(this.topArticle.title);
        JSONObject object = new JSONObject();
        object.put((Object)"top", (Object)this.topArticle.toJson());
        if (this.subArticles != null) {
            JSONArray jsonArray = new JSONArray();
            object.put((Object)"subArticles", (Object)jsonArray);
            for (Article article : this.subArticles) {
                jsonArray.add((Object)article.toJson());
            }
        }
        payload.setBase64edData(Base64.getEncoder().encodeToString(object.toString().getBytes()));
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        try {
            super.decode(payload);
            JSONObject object = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(payload.getBase64edData())));
            JSONObject topObj = (JSONObject)object.get((Object)"top");
            this.topArticle = Article.fromJson(topObj);
            JSONArray jsonArray = (JSONArray)object.get((Object)"subArticles");
            if (jsonArray != null && jsonArray.size() > 0) {
                this.subArticles = new ArrayList();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.subArticles.add(Article.fromJson((JSONObject)jsonArray.get(i)));
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public List<LinkMessageContent> toLinkMessageContent() {
        ArrayList<LinkMessageContent> contents = new ArrayList<LinkMessageContent>();
        contents.add(this.topArticle.toLinkMessageContent());
        if (this.subArticles != null) {
            for (Article article : this.subArticles) {
                contents.add(article.toLinkMessageContent());
            }
        }
        return contents;
    }

    public static class Article {
        public String articleId;
        public String cover;
        public String title;
        public String digest;
        public String url;
        boolean readReport;

        JSONObject toJson() {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)this.articleId);
            obj.put((Object)"cover", (Object)this.cover);
            obj.put((Object)"title", (Object)this.title);
            obj.put((Object)"digest", (Object)this.digest);
            obj.put((Object)"url", (Object)this.url);
            obj.put((Object)"rr", (Object)this.readReport);
            return obj;
        }

        static Article fromJson(JSONObject obj) {
            Article article = new Article();
            article.articleId = (String)obj.get((Object)"id");
            article.cover = (String)obj.get((Object)"cover");
            article.title = (String)obj.get((Object)"title");
            article.digest = (String)obj.get((Object)"digest");
            article.url = (String)obj.get((Object)"url");
            article.readReport = (Boolean)obj.get((Object)"rr");
            return article;
        }

        public LinkMessageContent toLinkMessageContent() {
            LinkMessageContent content = new LinkMessageContent(this.title, this.url);
            content.setContentDigest(this.digest);
            content.setThumbnailUrl(this.cover);
            return content;
        }
    }
}

