/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import cn.wildfirechat.sdk.model.QuoteInfo;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.util.TextUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TextMessageContent
extends MessageContent {
    private String text;
    private QuoteInfo quoteInfo;

    public TextMessageContent() {
    }

    public TextMessageContent(String text) {
        this.text = text;
    }

    public TextMessageContent text(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public QuoteInfo getQuoteInfo() {
        return this.quoteInfo;
    }

    public void setQuoteInfo(QuoteInfo quoteInfo) {
        this.quoteInfo = quoteInfo;
    }

    @Override
    public int getContentType() {
        return 1;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setSearchableContent(this.text);
        if (this.quoteInfo != null) {
            payload.setBase64edData(Base64.getEncoder().encodeToString(this.quoteInfo.encode().toJSONString().getBytes(StandardCharsets.UTF_8)));
        }
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.text = payload.getSearchableContent();
        if (!TextUtils.isEmpty((CharSequence)payload.getBase64edData())) {
            String jsonStr = new String(Base64.getDecoder().decode(payload.getBase64edData()), StandardCharsets.UTF_8);
            try {
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonStr);
                this.quoteInfo = new QuoteInfo();
                this.quoteInfo.decode(jsonObject);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

