/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.common.ErrorCode;
import cn.wildfirechat.pojos.InputOutputUserInfo;
import cn.wildfirechat.pojos.OutputCreateGroupResult;
import cn.wildfirechat.pojos.OutputCreateUser;
import cn.wildfirechat.pojos.PojoGroupInfo;
import cn.wildfirechat.pojos.PojoGroupMember;
import cn.wildfirechat.sdk.AdminConfig;
import cn.wildfirechat.sdk.GroupAdmin;
import cn.wildfirechat.sdk.RelationAdmin;
import cn.wildfirechat.sdk.UserAdmin;
import cn.wildfirechat.sdk.model.IMResult;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class GenerateTestData {
    private static String AdminUrl = "http://10.206.0.5:18080";
    private static String AdminSecret = "123456";
    private static int totalUserCount = 20000;
    private static int friendCount = 100;
    private static int smallGroupCount = 100;
    private static int smallGroupMemberSize = 20;
    private static int middleGroupCount = 100;
    private static int middleGroupMemberSize = 100;
    private static int bigGroupCount = 20;
    private static int bigGroupMemberSize = 1000;
    private static int splitFileCount = 1;
    private static AtomicInteger addFriendCount = new AtomicInteger(0);
    private static AtomicInteger createGroupCount = new AtomicInteger(0);

    public static void main(String[] args) throws Exception {
        AdminConfig.initAdmin(AdminUrl, AdminSecret);
        int addFriendRequestCount = friendCount * totalUserCount / 2;
        int createSmallGroupCount = smallGroupCount * totalUserCount / smallGroupMemberSize;
        int createMiddleGroupCount = middleGroupCount * totalUserCount / middleGroupMemberSize;
        int createBigGroupCount = bigGroupCount * totalUserCount / bigGroupMemberSize;
        System.out.println("\u6839\u636e\u5f53\u524d\u7684\u53c2\u6570\uff0c\u5c06\u521b\u5efa " + totalUserCount + " \u540d\u7528\u6237");
        System.out.println("\u6dfb\u52a0\u5927\u6982 " + addFriendRequestCount + " \u6b21\u597d\u53cb\u8bf7\u6c42");
        System.out.println("\u521b\u5efa\u5927\u6982 " + createSmallGroupCount + " \u4e2a\u5c0f\u578b\u7fa4\u7ec4");
        System.out.println("\u521b\u5efa\u5927\u6982 " + createMiddleGroupCount + " \u4e2a\u4e2d\u7b49\u7fa4\u7ec4");
        System.out.println("\u521b\u5efa\u5927\u6982 " + createBigGroupCount + " \u4e2a\u5927\u578b\u7fa4\u7ec4");
        System.out.println("\u7b49\u5f8510\u79d2\u5f00\u59cb");
        Thread.sleep(10000L);
        List<String> userIds = GenerateTestData.generateUserIds(totalUserCount);
        CountDownLatch latch = new CountDownLatch(5);
        new Thread(() -> {
            GenerateTestData.createUsers(userIds);
            latch.countDown();
        }).start();
        HashMap<String, Integer> unfulfilledFriendMap = new HashMap<String, Integer>();
        new Thread(() -> {
            GenerateTestData.addFriends(userIds, friendCount, unfulfilledFriendMap);
            latch.countDown();
        }).start();
        HashMap userSmallGroupMap = new HashMap();
        HashMap<String, Integer> unfulfilledSmallMap = new HashMap<String, Integer>();
        new Thread(() -> {
            for (String userId : userIds) {
                GenerateTestData.createGroup(userId, userIds, userSmallGroupMap, smallGroupCount, smallGroupMemberSize, unfulfilledSmallMap);
            }
            latch.countDown();
        }).start();
        HashMap userMiddleGroupMap = new HashMap();
        HashMap<String, Integer> unfulfilledMiddleMap = new HashMap<String, Integer>();
        new Thread(() -> {
            for (String userId : userIds) {
                GenerateTestData.createGroup(userId, userIds, userMiddleGroupMap, middleGroupCount, middleGroupMemberSize, unfulfilledMiddleMap);
            }
            latch.countDown();
        }).start();
        HashMap userBigGroupMap = new HashMap();
        HashMap<String, Integer> unfulfilledBigMap = new HashMap<String, Integer>();
        new Thread(() -> {
            for (String userId : userIds) {
                GenerateTestData.createGroup(userId, userIds, userBigGroupMap, bigGroupCount, bigGroupMemberSize, unfulfilledBigMap);
            }
            latch.countDown();
        }).start();
        latch.await();
        System.out.println("\u6570\u636e\u521d\u59cb\u5316\u7ed3\u675f\uff0c\u5b9e\u9645\u5efa\u7acb\u597d\u53cb\u5173\u7cfb: " + addFriendCount.get() + " \u6761\u3002");
        if (!unfulfilledFriendMap.isEmpty()) {
            System.out.println("\u6709\u90e8\u5206\u7528\u6237\u6ca1\u6709\u5efa\u7acb" + friendCount + "\u4e2a\u597d\u53cb\u5173\u7cfb\uff0c\u5206\u522b\u662f\uff1a");
            GenerateTestData.printUnfulfilledMap(unfulfilledFriendMap);
        }
        System.out.println("\u6570\u636e\u521d\u59cb\u5316\u7ed3\u675f\uff0c\u521b\u5efa\u7fa4\u7ec4: " + createGroupCount.get() + " \u4e2a\u3002");
        if (!unfulfilledSmallMap.isEmpty()) {
            System.out.println("\u6709\u90e8\u5206\u7528\u6237\u6ca1\u6709\u5efa\u7acb" + smallGroupMemberSize + "\u4e2a\u7fa4\u7ec4\u6210\u5458\u7684\u7fa4\uff0c\u5206\u522b\u662f\uff1a");
            GenerateTestData.printUnfulfilledMap(unfulfilledSmallMap);
        }
        if (!unfulfilledMiddleMap.isEmpty()) {
            System.out.println("\u6709\u90e8\u5206\u7528\u6237\u6ca1\u6709\u5efa\u7acb" + middleGroupMemberSize + "\u4e2a\u7fa4\u7ec4\u6210\u5458\u7684\u7fa4\uff0c\u5206\u522b\u662f\uff1a");
            GenerateTestData.printUnfulfilledMap(unfulfilledMiddleMap);
        }
        if (!unfulfilledBigMap.isEmpty()) {
            System.out.println("\u6709\u90e8\u5206\u7528\u6237\u6ca1\u6709\u5efa\u7acb" + bigGroupMemberSize + "\u4e2a\u7fa4\u7ec4\u6210\u5458\u7684\u7fa4\uff0c\u5206\u522b\u662f\uff1a");
            GenerateTestData.printUnfulfilledMap(unfulfilledBigMap);
        }
        System.out.println("\u4fdd\u5b58\u6570\u636e\u5230" + splitFileCount + "\u4e2a\u6587\u4ef6\u4e2d\u3002");
        for (int i = 0; i < splitFileCount; ++i) {
            String filePath = "data" + i + ".csv";
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
            int partSize = totalUserCount / splitFileCount;
            for (int j = 0; j < partSize; ++j) {
                String userId = userIds.get(i * partSize + j);
                GenerateTestData.writeDeviceInfo(writer, userId, 3);
                Set smallGroupIds = (Set)userSmallGroupMap.get(userId);
                GenerateTestData.writeGroupIds(writer, smallGroupIds);
                Set middleGroupIds = (Set)userMiddleGroupMap.get(userId);
                GenerateTestData.writeGroupIds(writer, middleGroupIds);
                Set bigGroupIds = (Set)userBigGroupMap.get(userId);
                GenerateTestData.writeGroupIds(writer, bigGroupIds);
            }
            writer.close();
        }
        System.out.println("\u4fdd\u5b58\u7ed3\u675f\u3002");
    }

    private static void printUnfulfilledMap(Map<String, Integer> map) {
        if (map.isEmpty()) {
            return;
        }
        map.forEach((s, integer) -> System.out.print(s + ":" + integer + " "));
        System.out.println();
    }

    private static void writeDeviceInfo(BufferedWriter writer, String userId, int platform) throws IOException {
        writer.write(userId);
        writer.write(",");
        writer.write(UUID.randomUUID().toString());
        writer.write(",");
        writer.write("" + platform);
        writer.write("\n");
    }

    private static void writeGroupIds(BufferedWriter writer, Set<String> groupIds) throws IOException {
        int writeCount = 0;
        for (String bigGroupId : groupIds) {
            writer.write(bigGroupId);
            if (++writeCount < groupIds.size()) {
                writer.write(",");
                continue;
            }
            writer.write("\n");
        }
    }

    private static void createGroup(String userId, List<String> userIds, Map<String, Set<String>> userGroupMap, int groupCount, int memberSize, Map<String, Integer> unfulfilledUserMap) {
        Set groupIds = userGroupMap.computeIfAbsent(userId, s -> new HashSet());
        int i = 0;
        while (groupIds.size() < groupCount) {
            Object memberGroupIds;
            PojoGroupInfo groupInfo = new PojoGroupInfo();
            groupInfo.setTarget_id(UUID.randomUUID().toString());
            groupInfo.setOwner(userId);
            groupInfo.setName("Group_" + userId + i++);
            groupInfo.setType(2);
            groupIds.add(groupInfo.getTarget_id());
            ArrayList<String> memberCandidates = new ArrayList<String>(userIds);
            ArrayList<String> memberIds = new ArrayList<String>();
            memberIds.add(userId);
            while (!memberCandidates.isEmpty() && memberIds.size() < memberSize) {
                String memberId = (String)memberCandidates.get((int)(Math.random() * (double)memberCandidates.size()));
                memberCandidates.remove(memberId);
                if (memberId.equals(userId) || memberIds.contains(memberId) || (memberGroupIds = userGroupMap.computeIfAbsent(memberId, s -> new HashSet())).contains(groupInfo.getTarget_id()) || memberGroupIds.size() >= groupCount) continue;
                memberGroupIds.add(groupInfo.getTarget_id());
                memberIds.add(memberId);
            }
            ArrayList<PojoGroupMember> members = new ArrayList<PojoGroupMember>();
            memberGroupIds = memberIds.iterator();
            while (memberGroupIds.hasNext()) {
                String memberId = (String)memberGroupIds.next();
                PojoGroupMember member1 = new PojoGroupMember();
                member1.setMember_id(memberId);
                members.add(member1);
            }
            try {
                IMResult<OutputCreateGroupResult> resultCreateGroup = GroupAdmin.createGroup(groupInfo.getOwner(), groupInfo, members, null, null, null);
                if (resultCreateGroup != null && resultCreateGroup.getErrorCode() == ErrorCode.ERROR_CODE_SUCCESS) {
                    System.out.println("create group success");
                } else {
                    System.out.println("create group failure");
                    System.exit(-1);
                }
            }
            catch (Exception e) {
                System.out.println("create group failure:" + e);
                System.exit(-1);
            }
            createGroupCount.incrementAndGet();
            if (memberIds.size() >= memberSize) continue;
            unfulfilledUserMap.put(userId + "'s group " + groupInfo.getTarget_id(), memberIds.size());
            System.out.println("Error, can not find enough user to create group for user:" + userId);
        }
    }

    private static void addFriends(List<String> userIds, int count, Map<String, Integer> unfulfilledFriendMap) {
        ConcurrentLinkedQueue<Pair<String, String>> toAddSet = new ConcurrentLinkedQueue<Pair<String, String>>();
        HashMap<String, Set> userFriends = new HashMap<String, Set>();
        for (String userId : userIds) {
            ArrayList<String> candidates = new ArrayList<String>(userIds);
            Set currentUserFriends = userFriends.computeIfAbsent(userId, s -> new HashSet());
            while (!candidates.isEmpty() && currentUserFriends.size() < count) {
                Set targetUserFriends;
                String friendId = (String)candidates.get((int)(Math.random() * (double)candidates.size()));
                candidates.remove(friendId);
                if (friendId.equals(userId) || currentUserFriends.contains(friendId) || (targetUserFriends = userFriends.computeIfAbsent(friendId, s -> new HashSet())).size() >= count) continue;
                currentUserFriends.add(friendId);
                targetUserFriends.add(userId);
                toAddSet.add(new Pair<String, String>(userId, friendId));
            }
            if (currentUserFriends.size() >= count) continue;
            unfulfilledFriendMap.put(userId, currentUserFriends.size());
            System.out.println("Error, can not find enough user to add friend for user:" + userId);
        }
        int threadNum = 5;
        CountDownLatch latch = new CountDownLatch(threadNum);
        for (int i = 0; i < threadNum; ++i) {
            new Thread(() -> {
                while (true) {
                    Pair pair;
                    if ((pair = (Pair)toAddSet.poll()) == null) break;
                    try {
                        IMResult<Void> result = RelationAdmin.setUserFriend((String)pair.first, (String)pair.second, true, null);
                        if (result != null && (result.getErrorCode() == ErrorCode.ERROR_CODE_SUCCESS || result.getErrorCode() == ErrorCode.ERROR_CODE_ALREADY_FRIENDS)) {
                            System.out.println("add friend success");
                            addFriendCount.incrementAndGet();
                            continue;
                        }
                        System.out.println("failure");
                        System.exit(-1);
                    }
                    catch (Exception e) {
                        System.out.println("failure:" + e);
                        System.exit(-1);
                    }
                }
                latch.countDown();
            }).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            System.out.println("failure:" + e);
            System.exit(-1);
        }
    }

    private static String generateUserId(int index) {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static List<String> generateUserIds(int count) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            userIds.add(GenerateTestData.generateUserId(i));
        }
        return userIds;
    }

    private static void createUsers(List<String> userIds) {
        for (int i = 0; i < userIds.size(); ++i) {
            InputOutputUserInfo userInfo = GenerateTestData.generateUserInfo(userIds.get(i), i);
            try {
                IMResult<OutputCreateUser> resultCreateUser = UserAdmin.createUser(userInfo);
                if (resultCreateUser != null && resultCreateUser.getErrorCode() == ErrorCode.ERROR_CODE_SUCCESS) {
                    System.out.println("Create user " + resultCreateUser.getResult().getName() + " success");
                    continue;
                }
                System.out.println("Create user failure");
                System.exit(-1);
                continue;
            }
            catch (Exception e) {
                System.out.println("Create user failure");
                System.exit(-1);
            }
        }
    }

    private static InputOutputUserInfo generateUserInfo(String userId, int index) {
        InputOutputUserInfo userInfo = new InputOutputUserInfo();
        userInfo.setUserId(userId);
        userInfo.setName(userId);
        userInfo.setMobile(11000000000L + (long)index + "");
        userInfo.setDisplayName("User" + index);
        return userInfo;
    }

    static class Pair<K, V> {
        K first;
        V second;

        public Pair() {
        }

        public Pair(K first, V second) {
            this.first = first;
            this.second = second;
        }
    }
}

