/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.InputApplicationGetUserInfo;
import cn.wildfirechat.pojos.InputChannelSubscribe;
import cn.wildfirechat.pojos.InputGetUserInfo;
import cn.wildfirechat.pojos.InputModifyChannelInfo;
import cn.wildfirechat.pojos.InputOutputUserInfo;
import cn.wildfirechat.pojos.InputUserId;
import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.pojos.OutputApplicationConfigData;
import cn.wildfirechat.pojos.OutputApplicationUserInfo;
import cn.wildfirechat.pojos.OutputGetChannelInfo;
import cn.wildfirechat.pojos.OutputStringList;
import cn.wildfirechat.pojos.SendChannelMessageData;
import cn.wildfirechat.pojos.SendMessageResult;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.ChannelHttpUtils;
import com.google.gson.Gson;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class ChannelServiceApi {
    private final ChannelHttpUtils channelHttpUtils;

    public ChannelServiceApi(String imurl, String channelId, String secret) {
        this.channelHttpUtils = new ChannelHttpUtils(imurl, channelId, secret);
    }

    public IMResult<InputOutputUserInfo> getUserInfo(String userId) throws Exception {
        String path = "/channel/user_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(userId, null, null);
        return this.channelHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public IMResult<InputOutputUserInfo> getUserInfoByName(String userName) throws Exception {
        String path = "/channel/user_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(null, userName, null);
        return this.channelHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public IMResult<InputOutputUserInfo> getUserInfoByMobile(String mobile) throws Exception {
        String path = "/channel/user_info";
        InputGetUserInfo getUserInfo = new InputGetUserInfo(null, null, mobile);
        return this.channelHttpUtils.httpJsonPost(path, getUserInfo, InputOutputUserInfo.class);
    }

    public IMResult<Void> modifyChannelInfo(int type, String value) throws Exception {
        String path = "/channel/update_profile";
        InputModifyChannelInfo modifyChannelInfo = new InputModifyChannelInfo();
        modifyChannelInfo.setType(type);
        modifyChannelInfo.setValue(value);
        return this.channelHttpUtils.httpJsonPost(path, modifyChannelInfo, Void.class);
    }

    public IMResult<OutputGetChannelInfo> getChannelInfo() throws Exception {
        String path = "/channel/get_profile";
        return this.channelHttpUtils.httpJsonPost(path, null, OutputGetChannelInfo.class);
    }

    public IMResult<Void> modifyChannelMenu(List<OutputGetChannelInfo.OutputMenu> menus) throws Exception {
        String menuStr = new Gson().toJson(menus);
        return this.modifyChannelInfo(7, menuStr);
    }

    public IMResult<SendMessageResult> sendMessage(int line, List<String> targets, MessagePayload payload) throws Exception {
        String path = "/channel/message/send";
        SendChannelMessageData messageData = new SendChannelMessageData();
        messageData.setLine(line);
        messageData.setTargets(targets);
        messageData.setPayload(payload);
        return this.channelHttpUtils.httpJsonPost(path, messageData, SendMessageResult.class);
    }

    public IMResult<Void> subscribe(String userId) throws Exception {
        String path = "/channel/subscribe";
        InputChannelSubscribe input = new InputChannelSubscribe();
        input.setTarget(userId);
        input.setSubscribe(1);
        return this.channelHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public IMResult<Void> unsubscribe(String userId) throws Exception {
        String path = "/channel/subscribe";
        InputChannelSubscribe input = new InputChannelSubscribe();
        input.setTarget(userId);
        input.setSubscribe(0);
        return this.channelHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public IMResult<OutputStringList> getSubscriberList() throws Exception {
        String path = "/channel/subscriber_list";
        return this.channelHttpUtils.httpJsonPost(path, null, OutputStringList.class);
    }

    public IMResult<Boolean> isSubscriber(String userId) throws Exception {
        String path = "/channel/is_subscriber";
        InputUserId input = new InputUserId(userId);
        return this.channelHttpUtils.httpJsonPost(path, input, Boolean.class);
    }

    public IMResult<OutputApplicationUserInfo> applicationGetUserInfo(String authCode) throws Exception {
        String path = "/channel/application/get_user_info";
        InputApplicationGetUserInfo input = new InputApplicationGetUserInfo();
        input.setAuthCode(authCode);
        return this.channelHttpUtils.httpJsonPost(path, input, OutputApplicationUserInfo.class);
    }

    public OutputApplicationConfigData getApplicationSignature() {
        int nonce = (int)(Math.random() * 100000.0 + 3.0);
        long timestamp = System.currentTimeMillis() / 1000L;
        String str = nonce + "|" + this.channelHttpUtils.getChannelId() + "|" + timestamp + "|" + this.channelHttpUtils.getChannelSecret();
        String sign = DigestUtils.sha1Hex((String)str);
        OutputApplicationConfigData configData = new OutputApplicationConfigData();
        configData.setAppId(this.channelHttpUtils.getChannelId());
        configData.setAppType(1);
        configData.setTimestamp(timestamp);
        configData.setNonceStr(nonce + "");
        configData.setSignature(sign);
        return configData;
    }
}

