/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.InputChannelId;
import cn.wildfirechat.pojos.InputCreateChannel;
import cn.wildfirechat.pojos.InputSubscribeChannel;
import cn.wildfirechat.pojos.OutputBooleanValue;
import cn.wildfirechat.pojos.OutputCreateChannel;
import cn.wildfirechat.pojos.OutputGetChannelInfo;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;

public class ChannelAdmin {
    public static IMResult<OutputCreateChannel> createChannel(InputCreateChannel inputCreateChannel) throws Exception {
        String path = "/admin/channel/create";
        return AdminHttpUtils.httpJsonPost(path, inputCreateChannel, OutputCreateChannel.class);
    }

    public static IMResult<Void> destroyChannel(String channelId) throws Exception {
        String path = "/admin/channel/destroy";
        InputChannelId inputChannelId = new InputChannelId(channelId);
        return AdminHttpUtils.httpJsonPost(path, inputChannelId, Void.class);
    }

    public static IMResult<OutputGetChannelInfo> getChannelInfo(String channelId) throws Exception {
        String path = "/admin/channel/get";
        InputChannelId inputChannelId = new InputChannelId(channelId);
        return AdminHttpUtils.httpJsonPost(path, inputChannelId, OutputGetChannelInfo.class);
    }

    public static IMResult<Void> subscribeChannel(String channelId, String userId) throws Exception {
        String path = "/admin/channel/subscribe";
        InputSubscribeChannel input = new InputSubscribeChannel(channelId, userId, 1);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<Void> unsubscribeChannel(String channelId, String userId) throws Exception {
        String path = "/admin/channel/subscribe";
        InputSubscribeChannel input = new InputSubscribeChannel(channelId, userId, 0);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputBooleanValue> isUserSubscribedChannel(String userId, String channelId) throws Exception {
        String path = "/admin/channel/is_subscribed";
        InputSubscribeChannel input = new InputSubscribeChannel(channelId, userId, 0);
        return AdminHttpUtils.httpJsonPost(path, input, OutputBooleanValue.class);
    }
}

