/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.pojos.mesh;

import com.google.gson.Gson;

public class MeshRestResult<T> {
    private static Gson gson = new Gson();
    private int remote_im_code;
    private int remote_mesh_code;
    private int local_mesh_code;
    private String error_message;
    private T result;

    public String toString() {
        return gson.toJson((Object)this);
    }

    public static MeshRestResult ok() {
        return new MeshRestResult();
    }

    public static MeshRestResult ok(Object object) {
        return new MeshRestResult<Object>(object);
    }

    public static MeshRestResult remoteIMError(int code, String message) {
        MeshRestResult r = new MeshRestResult();
        r.remote_im_code = code;
        r.error_message = message;
        return r;
    }

    public static MeshRestResult remoteMeshError(int code, String message) {
        MeshRestResult r = new MeshRestResult();
        r.remote_mesh_code = code;
        r.error_message = message;
        return r;
    }

    public MeshRestResult addRemoteMeshError(int code, String message) {
        MeshRestResult<T> r = new MeshRestResult<T>();
        this.remote_mesh_code = code;
        this.error_message = message;
        return this;
    }

    public static MeshRestResult localMeshError(int code, String message) {
        MeshRestResult r = new MeshRestResult();
        r.local_mesh_code = code;
        r.error_message = message;
        return r;
    }

    public MeshRestResult addLocalMeshError(int code, String message) {
        this.local_mesh_code = code;
        this.error_message = message;
        return this;
    }

    public MeshRestResult() {
    }

    public MeshRestResult(T object) {
        this.result = object;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public int getRemote_im_code() {
        return this.remote_im_code;
    }

    public void setRemote_im_code(int remote_im_code) {
        this.remote_im_code = remote_im_code;
    }

    public int getRemote_mesh_code() {
        return this.remote_mesh_code;
    }

    public void setRemote_mesh_code(int remote_mesh_code) {
        this.remote_mesh_code = remote_mesh_code;
    }

    public int getLocal_mesh_code() {
        return this.local_mesh_code;
    }

    public void setLocal_mesh_code(int local_mesh_code) {
        this.local_mesh_code = local_mesh_code;
    }

    public String getError_message() {
        return this.error_message;
    }

    public void setError_message(String error_message) {
        this.error_message = error_message;
    }

    public static enum MeshRestCode {
        SUCCESS(0, "success"),
        ERROR_INVALID_MOBILE(1, "\u65e0\u6548\u7684\u7535\u8bdd\u53f7\u7801"),
        ERROR_SEND_SMS_OVER_FREQUENCY(3, "\u8bf7\u6c42\u9a8c\u8bc1\u7801\u592a\u9891\u7e41"),
        ERROR_SERVER_ERROR(4, "\u670d\u52a1\u5668\u5f02\u5e38"),
        ERROR_CODE_EXPIRED(5, "\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f"),
        ERROR_CODE_INCORRECT(6, "\u9a8c\u8bc1\u7801\u6216\u5bc6\u7801\u9519\u8bef"),
        ERROR_SERVER_CONFIG_ERROR(7, "\u670d\u52a1\u5668\u914d\u7f6e\u9519\u8bef"),
        ERROR_SESSION_EXPIRED(8, "\u4f1a\u8bdd\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f"),
        ERROR_SESSION_NOT_VERIFIED(9, "\u4f1a\u8bdd\u6ca1\u6709\u9a8c\u8bc1"),
        ERROR_SESSION_NOT_SCANED(10, "\u4f1a\u8bdd\u6ca1\u6709\u88ab\u626b\u7801"),
        ERROR_SERVER_NOT_IMPLEMENT(11, "\u529f\u80fd\u6ca1\u6709\u5b9e\u73b0"),
        ERROR_GROUP_ANNOUNCEMENT_NOT_EXIST(12, "\u7fa4\u516c\u544a\u4e0d\u5b58\u5728"),
        ERROR_NOT_LOGIN(13, "\u6ca1\u6709\u767b\u5f55"),
        ERROR_NO_RIGHT(14, "\u6ca1\u6709\u6743\u9650"),
        ERROR_INVALID_PARAMETER(15, "\u65e0\u6548\u53c2\u6570"),
        ERROR_NOT_EXIST(16, "\u5bf9\u8c61\u4e0d\u5b58\u5728"),
        ERROR_USER_NAME_ALREADY_EXIST(17, "\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728"),
        ERROR_SESSION_CANCELED(18, "\u4f1a\u8bdd\u5df2\u7ecf\u53d6\u6d88"),
        ERROR_PASSWORD_INCORRECT(19, "\u5bc6\u7801\u9519\u8bef"),
        ERROR_FAILURE_TOO_MUCH_TIMES(20, "\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u592a\u591a\uff0c\u8bf7\u7b495\u5206\u949f\u518d\u8bd5\u8bd5"),
        ERROR_USER_FORBIDDEN(21, "\u7528\u6237\u88ab\u5c01\u7981");

        public int code;
        public String msg;

        private MeshRestCode(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }
    }
}

