package com.bcxin.ars.hbase.dao;

import java.util.List;
import java.util.Map;

/**
 * hbase dao 层操作基类
 * Created by subh on 2017/6/7.
 */
public interface BaseDAO<T> {
    /**
     * 保存对象
     * @param object
     * @return
     */
    void save(T object) throws Exception ;
    /***
     * 查询
     * @param map 字段列表
     * @param object 对象
     * @return
     * @throws Exception
     */
    List<T> query(Map<String,String> map, T object)throws Exception;
    /***
     * 根据ID获取对象
     * @param id 主键
     * @return
     */
    T get(Object id);
    /***
     * 根据id删除对象
     * @param id 主键
     */
    void detele(Object id);
}
