package com.bcxin.ars.dao;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.Config;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class ConfigDaoTest {

	@Autowired
	private ConfigDao configDao;
	
	@Test
	public void testFindAll() {
		List<Config> configs = configDao.findAll();
//		System.out.println(configs.size());
		Assert.assertNotNull(configs);
	}
	
	@Test
	public void testFindByCode() {
		String key="gender";
		Config config = configDao.findByKey(key);
//		System.out.println(config.getName());
		Assert.assertNotNull(config);
	}
}
