package com.bcxin.ars.dao.conference;

import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.conference.PoliceAccountSearchDto;
import com.bcxin.ars.model.conference.ConferenceAccount;
import org.apache.ibatis.annotations.Param;

import java.util.List;
/***
 * 会议帐号信息数据层
 * @author subh
 */
public interface ConferenceAccountDao {
    /***
     * 保存
     * @param record
     * @return
     */
    int insert(ConferenceAccount record);
    /***
     * 根据用户ID查询
     * @param userId
     * @return
     */
    ConferenceAccount selectByUserId(@Param("userId")Long userId);
    /***
     * 根据用户ID更新状态
     * @param record
     * @return
     */
    int updateByUserId(ConferenceAccount record);

    /****
     * 获取公安会议账号列表
     * @return
     */
    List<ZTree> getPoliceAccountTree(PoliceAccountSearchDto searchDto);

}