package com.bcxin.ars.dao.conference;

import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.conference.ConferenceSearchDto;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.conference.CloudConference;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
/***
 * 会议信息数据层
 * @author subh
 */
public interface CloudConferenceDao {

    int deleteByPrimaryKey(Integer id);

    int insert(CloudConference record);

    CloudConference findById(Long id);

    List<CloudConference> selectAll();

    int update(CloudConference record);

    void updateState(CloudConference record);


    /***
     *
     * 更新是否有主席
     * @param record
     */
    void updateChairmanState(CloudConference record);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<CloudConference> searchForPage(ConferenceSearchDto searchDto, AjaxPageResponse<Appeal> page);

    List<CloudConference> findUnEnd();

    void end(String meetId);
    /**
     * 根据meetId获取会议信息
     * @param meetId
     * @return
     */
    CloudConference findByMeetId(String meetId);

    /***
     * 结束昨天的会议信息
     * @param record
     * @return
     */
    int endYesterday(CloudConference record);
}