package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityCompanyPersonDTO;
import com.bcxin.ars.model.SecurityCompanyPerson;
import org.apache.ibatis.annotations.Param;

public interface SecurityCompanyPersonDao {
	
	Long save(SecurityCompanyPerson companyPerson);
	/**
	 *
	 * @Decription:批量更新
	 * @author：zhongjianhui
	 * @method  updateBatch
	 * @date：2018/11/19 16:06
	 * @params： * @param relationList
	 * @return void
	 */
	void updateBatch(@Param("relationList")List<SecurityCompanyPersonDTO> relationList);

	void delete(SecurityCompanyPerson companyPerson);

	SecurityCompanyPerson findById(Long Id);
	
	SecurityCompanyPerson findByPersonId(Long personId);

	SecurityCompanyPerson findSingleByPersonId(Long personId);

	/***
	 * 根据人员ID查询人员与公司关系
	 * @param personId 人员ID
	 * @return 人员与公司关联表信息
	 */
	SecurityCompanyPerson findByPersonIdForImport(Long personId);
	
	List<SecurityCompanyPerson> findByRoleId(Long roleId);
	
	List<SecurityCompanyPerson> findByOrgId(Long orgId);

	void update(SecurityCompanyPerson companyPerson);

	void updateForDS(SecurityCompanyPerson companyPerson);
	
	List<SecurityCompanyPerson> searchForDataSynchronization( DataSynchronizationSearchDto searchDto);

	/*数据同步*/
	SecurityCompanyPerson findByPersonAndCompany(Long personId, Long companyId);

    void deleteByPersonId(Long personId);

    List<SecurityCompanyPerson> findBatchById(@Param("list") List<SecurityCompanyPerson> relationList);

	void saveBatch(@Param("list")List<SecurityCompanyPerson> list);
}
