package com.bcxin.ars.dao;

import com.bcxin.ars.dto.PerBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListDto;
import com.bcxin.ars.dto.page.PersonBlackListPageSearchDto;
import com.bcxin.ars.model.PersonBlackList;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 行业黑名单dao接口
 * @author linqinglin
 * @date 2019/05/13 0013 9:54
 */
public interface PersonBlackListDao {

    /**
     * 根据主键id查询
     * @param id
     * @return
     */
    PersonBlackList findById(Long id);

    /**
     * 新增
     * @param detail
     * @return
     */
    Long insert(PersonBlackList detail);

    /**
     * 修改
     * @param detail
     */
    void update(PersonBlackList detail);

    /**
     * 删除
     * @param detail
     */
    void delete(PersonBlackList detail);

    /***
     * 公安用户管理查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<PersonBlackList> searchForPage(PersonBlackListPageSearchDto dto, AjaxPageResponse<PersonBlackListDto> ajaxPageResponse);
    /***
     * 根据id批量查询
     * @param list
     */
    List<PersonBlackList> findByBatchId(List<PersonBlackList> list);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PersonBlackList> list);
    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PersonBlackList> findDSOutList(String startDate);
    /**
     * 保存修改
     * @param detail
     */
    void save(PersonBlackList detail);

    /**
     * 根据更新时间查询保安行业黑名单人员
     * @param startTime
     * @param endTime
     * @return
     */
    List<PerBlackListDto> selectBlackByUpdateTime(@Param("startTime") Date startTime, @Param("endTime") Date endTime);
}
