package com.bcxin.ars.dao;

import java.util.List;

import com.bcxin.ars.model.Permission;
import org.apache.ibatis.annotations.Param;

/**
 * 权限数据访问类
 * @author Ethan
 */
public interface PermissionDao {

	/**
	 * 获取指定角色的权限
	 * @return
	 */
	List<Permission> findByRole(Long roleid, String roletype,String moduletype);

	/**
	 * 新增角色权限
	 * @param permission
	 */
	void save(Permission permission);


    /**
     * 批量新增角色权限
     * @param list 权限列表
     */
    void insertBatch(@Param("list")List<Permission> list);
	/**
	 * 删除角色权限
	 * @param permission
	 */
	void delete(Permission permission);
	
	/**
	 * 通过角色删除权限
	 * @param roleid
	 */
	void deleteByRole(Long roleid, String roletype);

	/**
	 * 获取指定角色的权限
	 * @return
	 */
	List<Permission> findByUserId(Long userid);
	/**
	 * 获取指定角色的权限
	 * @return
	 */
	List<Permission> findByGAUserId(Long userid);
	
	List<Permission> findAllForPlatform(@Param("platform") Integer platform);

	Permission findByOperationIdAndRoleId(Long operationid, Long roleid);

	List<Permission> findByRoleid(String roleid);

	List<Permission> findByRoleidAndType(Long roleid, String roletype);
	/**
	 * @Decription:批量保存
	 * @param list
	 */
    void saveBatch(@Param("list")List<Permission> permissionlist);
}
