package com.bcxin.ars.rest.shiro;

import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.Sha1Util;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;

/**
 * 
 * <b>Function </b>自定义密码验证
 * 
 * @author LinQingLin
 * @date 2017年3月16日 下午5:06:32
 * @注意事项 </b>
 * <b>
 */
public class CustomCredentialsMatcher extends SimpleCredentialsMatcher {

	@Override  
    public boolean doCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) {  
        UsernamePasswordToken token = (UsernamePasswordToken) authcToken;

        //判断如果SaaS单点登陆的话，则免去密码验证 add subh 2018-09-26 start
        if(Constants.SaaSCode.equals(token.getHost())){
            return true;
        }
        //判断如果SaaS单点登陆的话，则免去密码验证 add subh 2018-09-26 end


        //将密码加密与系统加密后的密码校验，内容一致就返回true,不一致就返回false  
        return Sha1Util.validatePassword(new String(token.getPassword()), (String)getCredentials(info));
    }  

}
