package com.bcxin.ars.rest.app;

import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.TaskTrack;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("app/person")
public class AppPersonController {
	private static final Logger logger = LoggerFactory.getLogger(AppPersonController.class);
	@Autowired
	private SecurityPersonService personService;
	/**
	 * 更新保安员位置
	 * @param appResult
	 * @return
	 */
	@RequestMapping("updateLocation")
	public @ResponseBody AppAjaxResult updateLocation(AppAjaxResult appResult) {
		AppAjaxResult result = new AppAjaxResult();
		try {
			TaskTrack track = appResult.getDecodeData(TaskTrack.class);
			SecurityPerson dbPerson = personService.findById(track.getPersonId());
			//经度维度不能是一样的
			if(!track.getLatitude().equals(track.getLongitude())) {
				dbPerson.setLatitude(track.getLatitude());
				dbPerson.setLongitude(track.getLongitude());
				personService.updateLocation(dbPerson);
				result.setSuccessful(true);
			} else {
				throw new RuntimeException("经度纬度一致，位置有问题:" + dbPerson.getId());
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

}
