package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.task.TaskTrack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.UUID;

@Controller
@RequestMapping("task")
public class TaskController {
	
	private static final Logger logger = LoggerFactory.getLogger(TaskController.class);
	/**
	 * 获取任务轨迹
	 * @return
	 */
	@RequestMapping("findTrackList/{feedbackId}")
	@Deprecated
	public @ResponseBody AjaxResult findTrackList(@PathVariable("feedbackId")Long feedbackId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			//List<TaskTrack> trackList = hBaseService.findByFeedbackId(feedbackId);
			result.setSuccessful(true);
			//result.setData(trackList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 记录任务轨迹用于与SaaS对接
	 * @param track 轨迹信息
	 * @return
	 */
	@RequestMapping("saas/saveTrack")
	public @ResponseBody AjaxResult saveTrackForSaaS(TaskTrack track) {
			AjaxResult result = new AjaxResult();
		try {
			//判断经纬度参数是否正常
			if(track.getLongitude() != null && track.getLongitude().trim().length() > 0
					&& track.getLatitude() != null && track.getLatitude().trim().length() > 0) {
				track.setUuid(UUID.randomUUID().toString());
				//hBaseService.save(track);
				result.setSuccessful(true);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}


}
