package com.bcxin.ars.dao.sb;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.model.sb.Firearms;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

public interface FirearmsDao {

	Firearms findById(long id);
	List<Firearms> findByAll();
	
	Long save(Firearms firearms);
	
	void update(Firearms firearms);
	
	List<Firearms> search(FirearmsSearchDto dto);
	
	Long searchCount(FirearmsSearchDto dto);

	void delete(Firearms firearms);

	List<Firearms> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveForDS(Firearms firearms);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	List<Firearms> searchForPage(FirearmsSearchDto searchDto, AjaxPageResponse<Firearms> page);
}
