package com.bcxin.ars.dao.task;

import java.util.List;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskFeedbackSearchDto;
import com.bcxin.ars.dto.task.FeedBackDetailDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.dto.task.TaskListDto;
import com.bcxin.ars.model.task.TaskFeedback;

/**
 * 任务反馈数据类
 * @author Ethan
 */
public interface TaskFeedbackDao {

	/**
	 * 根据ID获取任务反馈
	 * @param id
	 * @return
	 */
	TaskFeedback findById(Long id);
	/**
	 * 获取指定任务下指定反馈列表
	 * @param taskId
	 * @return
	 */
	TaskFeedback findByIdRand();
	/**
	 * 新增任务反馈
	 * @param taskFeedback
	 * @return
	 */
	Long save(TaskFeedback taskFeedback);
	
	/**
	 * 更新任务反馈
	 * @param taskFeedback
	 */
	void update(TaskFeedback taskFeedback);
	
	/**
	 * 任务历史搜索
	 * @param dto
	 * @return
	 */
	List<TaskFeedback> search(TaskFeedbackSearchDto dto);
	
	/**
	 * 任务历史数量搜索
	 * @param dto
	 * @return
	 */
	Long searchCount(TaskFeedbackSearchDto dto);
	
	/**
	 * 获取指定任务下指定反馈列表
	 * @param taskId
	 * @return
	 */
	List<TaskFeedback> findByTaskId(Long taskId);

	/**
	 * 获取指定任务下指定反馈列表(部分字段）
	 * @param taskId
	 * @return
	 */
	List<TaskFeedback> findFeedbackByTaskid(Long taskId,Long personId);
	List<TaskFeedback> findUrgentFeedbackByTaskid(Long taskId,Long personId);
	List<TaskFeedback> findAllFeedbackByTaskid(Long taskId,Long personId);

	/**
	 * 获取下一班次子任务
	 * @param taskId
	 * @return
	 */
	List<TaskFeedback> findFeedbackNext(Long taskId);
	
	/**
	 * 根据保安员获取其未反馈的任务
	 * @param personId
	 * @return
	 */
	List<TaskFeedback> findNotFeedback(Long personId);
	
	/**
	 * 任务区域画像
	 * @param companyId
	 * @return
	 */
	List<ReportData> findAreaReport(Long companyId);

	/**
	 * 任务种类画像
	 * @param companyId
	 * @return
	 */
	List<ReportData> findCatalogReport(Long companyId);

	/**
	 * 任务人员等级画像
	 * @param companyId
	 * @return
	 */
	List<ReportData> findLevelReport(Long companyId);

	void deleteByTaskIdPersonIdTaskDate(Long taskId, Long personId, String taskDate);

	/**
	 *
	 * <b>Function </b> 根据用户ID,任务状态，分钟数查询
	 *
	 * @param personId
	 * @param taskStatus
	 * @param minutes
	 * @return
	 * @author LinQingLin
	 * @date 2017年3月9日 下午5:55:07
	 * @注意事项 </b>
	 * <b>
	 */
	List<TaskFeedback> findFeedbackList(Long personId,Long taskStatus , Integer minutes);

	/***
	 * 根据任务ID和保安人员信息ID查询出保安人员执行任务的轨迹信息
	 * @param taskFeedback 任务反馈参数
	 * @return
	 */
	TaskFeedback findByTaskIdAndPerson(TaskFeedback taskFeedback);


	Long findAllWLTaskfeed(TaskFeedback taskFeedback);

	List<TaskFeedback> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	TaskFeedback findByRawId(Long rawid);
	
	TaskFeedback findByInRawId(Long inrawid);

	void delete(TaskFeedback feedback);
	
	List<TaskFeedBackDto> findFeedBasks(TaskDetailSearchDto taskDetailDto);
	
	TaskFeedBackDto findNearFeedBack_before(TaskDetailSearchDto taskDetailDto);
	
	TaskFeedBackDto findNearFeedBack_back(TaskDetailSearchDto taskDetailDto);

	/**
	 * 查询大于当前时间的下一班次，精确到秒
	 * @param taskListDto
	 * @return
	 */
	TaskFeedBackDto findNextFeedBack_back(TaskListDto taskListDto);
	
	/**
	 * 根据ID获取子任务详情信息
	 * @param id
	 * @return
	 */
	FeedBackDetailDto findFeedBackDetailById(Long id);
	/**V1.0.9
	 * 根据保安ID获取可签到子任务列表信息
	 * @param personId
	 * @return
	 */
	List<FeedBackDetailDto> findBackDetailByPersonid(Long personId);
	
	/**V1.0.9
	 * 更新任务底下所有子任务漏打卡状态
	 * @param taskId
	 * @param personId
	 */
	void updateFeedbackStatus(Long taskId, Long personId);
	
	/**
	 * V1.0.9
	 * 查询正在执行的子任务信息(未达到下班时间)
	 * @param taskId
	 * @param personId
	 * @return
	 */
	Long searchExecFeedBackCount(Long taskId, Long personId);
	
	/**
	 * V1.0.9
	 * 计算已完成班次总时长
	 * @param taskId
	 * @param personId
	 * @return
	 */
	Long findFeedBackFinishSumTime(Long taskId, Long personId);
	
	/**
	 * V1.0.9
	 * 根据任务ID,保安人员ID，班次状态查询班次列表
	 * @param taskId
	 * @param personId
	 * @param scheduleStatus
	 * @return
	 */
	List<TaskFeedBackDto> findFeedBasksByScheduleStatus(TaskDetailSearchDto taskDetailDto);
	/**
	 * V1.0.9
	 * 根据保安人员ID获取当前最早可签到的子任务ID
	 * @param personId
	 * @return
	 */
	Long findCanSignFeedBaskID(TaskDetailSearchDto taskDetailDto);
	
	/**
	 * 获取指定任务下指定反馈列表(部分字段）
	 * @param taskId
	 * @param personId
	 * @return
	 */
	List<TaskFeedback> findFeedbackByTaskid_V109(Long taskId,Long personId);
}
