package com.bcxin.ars.dao.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.page.task.ComContractStationSearchDto;
import com.bcxin.ars.model.sb.GradePractice;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.task.ComContractStation;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 合同dao接口
 */
public interface ComContractStationDao {
    /**
     * 外导内数据查询
     * @param dto
     * @return
     */
    //List<ComContractStation> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 根据id集合批量查询
     * @param list
     * @return
     */
    List<ComContractStation> findByBatchIds(@Param("list")List<ComContractStation> list);


    /**
     * 根据合同ID获取驻勤信息
     * @param comContractId
     * @return
     */
    List<ComContractStation> findByComContractId(Long comContractId);
    /**
     * 批量保存企业合同驻勤点
     * @param list
     */
    void saveBatch(@Param("list")List<ComContractStation> list);

    /***
     * 查询企业合同驻勤点
     * @param dto
     * @param page
     */
    List<ComContractStation>  search(ComContractStationSearchDto dto, AjaxPageResponse<ComContractStationSearchDto> page);

    /**
     * 删除企业合同驻勤点
     * @param comContractId
     * @return
     */
    void deleteBatchByComContractId(Long comContractId);
    /**
     * 删除企业合同驻勤点
     * @param list
     * @return
     */
    void deleteBatchIds(@Param("list") List<ComContractStation>   list);
}