package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface SubsidiaryDao {

	Subsidiary findById(Long id);

	Subsidiary findByIdWithOutCache(Long id);
	/**
	 *
	 * @Decription:批量查询
	 * @author：zhongjianhui
	 * @method  findByBatchId
	 * @date：2018/8/16 13:32
	 * @params： * @param approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Subsidiary>
	 */
	List<Subsidiary> findByBatchId(@Param("approvalList") List<Approval> approvalList);

	List<Subsidiary> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);

	Long save(Subsidiary subsidiary);

	void update(Subsidiary subsidiary);
	/**
	 *
	 * @Decription:批量插入
	 * @author：zhongjianhui
	 * @method  updateBatch
	 * @date：2018/8/16 13:39
	 * @params： * @param approvalList
	 * @return void
	 */
	void updateBatch(@Param("approvalList") List<Subsidiary> approvalList);

	List<Subsidiary> search(SubsidiarySearchDto dto);
	
	Long searchCount(SubsidiarySearchDto dto);

	Subsidiary findByUser(Long userid);

    List<Subsidiary> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<Subsidiary> findAll();

    int countSubsidiaryList(Map<Object, Object> p);

	List<Map<Object,Object>>  searchSubsidiaryList(Map<Object, Object> p);

    Subsidiary findApproveBySoncompanyname(Subsidiary subsidiary);

	List<Map<Object,Object>>  searchForPage(SubsidiarySearchDto dto, AjaxPageResponse<Subsidiary> page);

    List<Subsidiary> findUnIntegrated();
}
