package com.bcxin.ars.dao.sb;

import java.util.List;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.PerCerGrantPageSearchDto;
import com.bcxin.ars.model.sb.PerCerGrant;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

/**
 * 保安员证核发Dao接口
 * 
 * @author lin
 * @date 2022-09-01
 */
public interface PerCerGrantDao{

    /****
     * 删除
     * @param perCerGrant
     * @return
     */
    int delete(PerCerGrant perCerGrant);

    /****
     * 保存
     * @param perCerGrant
     * @return
     */
    int save(PerCerGrant perCerGrant);

    /****
     * 主键查询
     * @param id
     * @return
     */
     PerCerGrant findById(Long id);

    /****
     * 选择修改
     * @param perCerGrant
     * @return
     */
    int updateSelective(PerCerGrant perCerGrant);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<PerCerGrant> searchForPage(PerCerGrantPageSearchDto searchDto, AjaxPageResponse<PerCerGrant> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PerCerGrant> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PerCerGrant> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PerCerGrant> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerCerGrant> findByBatchId(@Param("list")List<PerCerGrant> list);


}
