package com.bcxin.ars.dao.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanyundoSearchDto;
import com.bcxin.ars.model.sb.Confesscompanyundo;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author：huangzp
 * @date：2018/04/09
 * @description：自招撤销备案DAO
 */
public interface ConfesscompanyundoDao {

    /**
     * 根据主键查询
     * @param id 主键
     * @return
     */
    Confesscompanyundo findById(Long id);

    Confesscompanyundo findByIdWithOutCache(Long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:17
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<Confesscompanyundo> findByBatchId(@Param("approvalList") List<Approval> approvalList);

    List<Confesscompanyundo> findByBatchIdWithOutCache(@Param("approvalList") List<Approval> approvalList);


    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:20
     * @params： * @param approvalList
     * @return void
     */
    void updateBatch(@Param("approvalList")List<Confesscompanyundo> approvalList);
    /**
     * 根据用户id获取未提交记录
     * @param userId
     * @return
     */
    Confesscompanyundo findUNSubmitByUser(Long userId);

    /**
     * 查询所有撤销备案申请记录
     * @return
     */
    List<Confesscompanyundo> findAll();

    /**
     * 新增
     * @param confesscompanyundo
     * @return
     */
    Long save(Confesscompanyundo confesscompanyundo);

    /**
     * 修改
     * @param confesscompanyundo
     */
    void update(Confesscompanyundo confesscompanyundo);

    /**
     * 删除
     * @param confesscompanyundo
     */
    void delete(Confesscompanyundo confesscompanyundo);

    /**
     * 审批
     * @param confesscompanyundo
     */
    void approve(Confesscompanyundo confesscompanyundo);

    /**
     * 更新审查状态
     * @param confesscompanyundo
     */
    void updateCensorStatus(Confesscompanyundo confesscompanyundo);

    /**
     * 搜索查询-记录数
     * @param dto
     * @return
     */
    Long searchCount(ConfesscompanyundoSearchDto dto);

    /**
     * 搜索查询
     * @param dto
     * @return
     */
    List<Confesscompanyundo> search(ConfesscompanyundoSearchDto dto);

    /**
     * 查询需要生成同步文件的记录
     * @param dto
     * @return
     */
    List<Confesscompanyundo> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 验证时候重复
     * @param map
     * @return
     */
    int checkDupliCompanyundo(Map<String,Object> map);

    int countConfesscompanyundoList(Map<Object, Object> p);

    List<Map<Object,Object>> searchConfesscompanyundoList(Map<Object, Object> p);

    Map<String,Object> selectApplyUserInfoWithId(Long id);

    List<Map<Object,Object>> searchForPage(ConfesscompanyundoSearchDto dto, AjaxPageResponse<Confesscompanyundo> page);
}
