package com.bcxin.ars.dao.appeal;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.model.appeal.Appeal;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/***
 * 申诉信息
 * @author subh
 */
public interface AppealDao {

    int delete(Long id);

    /****
     * 保存
     * @param record
     * @return
     */
    int insert(Appeal record);

    Appeal findById(Long id);

    int update(Appeal record);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    List<Appeal> searchForPage(AppealSearchDto searchDto, AjaxPageResponse<Appeal> page);
    Long appealCount(AppealSearchDto searchDto);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<Appeal> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<Appeal> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<Appeal> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<Appeal> findByBatchId(@Param("list") List<Appeal> list);

    /**
     * 根据审批id 获取申诉状态
     *
     * @param appealId 审批id
     * @return 申诉状态
     */
    String findAppealStatusById(Long appealId);

    /**
     * 查询该businessId是否有正在审查的记录
     *
     * @param appealInfo 记录
     * @return count
     */
    int selectCountByBusinessId(Appeal appealInfo);

    /**
     * 根据businessId 获取申诉
     *
     * @param businessId   businessId
     * @param businessType businessType
     * @return 申诉信息
     */
    List<Appeal> findByBusinessIdAndType(@Param("businessId") String businessId, @Param("businessType") String businessType);

    Appeal findOneByBusinessIdAndType(@Param("businessId") String businessId, @Param("businessType") String businessType);

    int selectCountByBusIdAndNum(Appeal appeal);
}