/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util.compose;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileUtil {
    public static String generatingFileNameByDate(String fileName) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String str = sdf.format(date);
        return fileName + "_" + str;
    }

    public static String getFileExtension(String fileName) {
        if (!fileName.isEmpty()) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static void deleteFolder(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    FileUtil.deleteFolder(f.getAbsolutePath());
                }
                file.delete();
            } else {
                System.out.println(file.delete());
            }
        }
    }

    public static void deleteFile(File folder, Date d) {
        File[] files;
        for (File f : files = folder.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.deleteFile(f, d);
                if (f.list().length != 0) continue;
                f.delete();
                continue;
            }
            if (f.lastModified() >= d.getTime()) continue;
            f.delete();
        }
    }

    public static void copyFolder(File resFile, File objFolderFile) throws IOException {
        if (!resFile.exists()) {
            return;
        }
        if (!objFolderFile.exists()) {
            objFolderFile.mkdirs();
        }
        if (resFile.isFile()) {
            int length;
            File objFile = new File(objFolderFile.getPath() + File.separator + resFile.getName());
            FileInputStream ins = new FileInputStream(resFile);
            FileOutputStream outs = new FileOutputStream(objFile);
            byte[] buffer = new byte[524288];
            while ((length = ((InputStream)ins).read(buffer)) != -1) {
                outs.write(buffer, 0, length);
            }
            ((InputStream)ins).close();
            outs.flush();
            outs.close();
        } else {
            String objFolder = objFolderFile.getPath() + File.separator + resFile.getName();
            File _objFolderFile = new File(objFolder);
            _objFolderFile.mkdirs();
            for (File sf : resFile.listFiles()) {
                FileUtil.copyFolder(sf, new File(objFolder));
            }
        }
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFile(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

