-- 表的结构 `eb_cheliangjichuxinxi`
CREATE TABLE `eb_cheliangjichuxinxi` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '创建用户id',
  `update_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '修改用户id',
  `owner_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '所属用户id',
  `chepaihao` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '车牌号',
  `cheliangleixing` int(11) NOT NULL DEFAULT '0' COMMENT '车辆类型',
  `changpaixinghao` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '厂牌型号',
  `goumaijiage` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '购买价格',
  `gouzhiriqi` date DEFAULT NULL COMMENT '购置日期',
  `fadongjibianhao` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '发动机编号',
  `cheliangtupian` text COLLATE utf8mb4_unicode_ci COMMENT '车辆图片',
  `beizhu` text COLLATE utf8mb4_unicode_ci COMMENT '备注',
  `frame_id` int(11) NOT NULL DEFAULT '0' COMMENT '部门ID',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
-- 表的结构 `eb_jiashiyuanxinxi`
CREATE TABLE `eb_jiashiyuanxinxi` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '创建用户id',
  `update_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '修改用户id',
  `owner_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '所属用户id',
  `guanliancheliang` int(11) NOT NULL DEFAULT '0' COMMENT '关联车辆',
  `jiashiyuanxingming` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '驾驶员姓名',
  `lianxidianhua` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '联系电话',
  `jiazhaoleixing` int(11) NOT NULL DEFAULT '0' COMMENT '驾照类型',
  `jiazhaobianhao` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '驾照编号',
  `jiazhaodaoqishijian` date DEFAULT NULL COMMENT '驾照到期时间',
  `beizhu` text COLLATE utf8mb4_unicode_ci COMMENT '备注',
  `frame_id` int(11) NOT NULL DEFAULT '0' COMMENT '部门ID',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
-- 表的结构 `eb_paichejilu`
CREATE TABLE `eb_paichejilu` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '创建用户id',
  `update_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '修改用户id',
  `owner_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '所属用户id',
  `paicheshuoming` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '派车说明',
  `guanliancheliang` int(11) NOT NULL DEFAULT '0' COMMENT '关联车辆',
  `guanlianjiashiyuan` int(11) NOT NULL DEFAULT '0' COMMENT '关联驾驶员',
  `paicheshijian` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '派车时间',
  `paicheren` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '派车人',
  `shoucheshijian` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '收车时间',
  `shoucheren` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '收车人',
  `beizhu` text COLLATE utf8mb4_unicode_ci COMMENT '备注',
  `guanlianyongcheshenqing` int(11) NOT NULL DEFAULT '0' COMMENT '关联用车申请',
  `paichezhuangtai` int(11) NOT NULL DEFAULT '0' COMMENT '派车状态',
  `frame_id` int(11) NOT NULL DEFAULT '0' COMMENT '部门ID',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
-- 转存表中的数据 `eb_system_crud`
INSERT INTO `eb_system_crud` (`id`, `table_name`, `table_name_en`, `cate_ids`, `info`, `crud_id`, `user_id`, `is_update_form`, `is_update_table`, `form_fields`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, '车辆基础信息', 'cheliangjichuxinxi', '/1/', '', 0, '1', 0, 0, '[\"chepaihao\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\",\"goumaijiage\",\"gouzhiriqi\",\"fadongjibianhao\",\"cheliangtupian\",\"chepaihao\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\",\"goumaijiage\",\"gouzhiriqi\"]', '2024-04-29 08:58:28', '2024-04-29 10:20:59', NULL),
(2, '驾驶员信息', 'jiashiyuanxinxi', '/1/', '', 0, '1', 0, 0, '[\"jiashiyuanxingming\",\"lianxidianhua\",\"jiazhaoleixing\",\"jiazhaobianhao\",\"jiazhaodaoqishijian\",\"beizhu\",\"jiashiyuanxingming\",\"lianxidianhua\",\"jiashiyuanxingming\"]', '2024-04-29 08:59:51', '2024-04-29 10:21:20', NULL),
(3, '用车申请', 'yongcheshenqing', '/1/', '', 0, '1', 0, 0, '[\"shenqingshiyou\",\"frame_id\",\"owner_user_id\",\"shenqingcheliang\",\"shenqingjiashiyuan\",\"kaishishijian\",\"jieshushijian\",\"qishiweizhi\",\"daodaweizhi\",\"yujilicheng\",\"beizhu\"]', '2024-04-29 09:00:00', '2024-04-30 08:56:18', NULL),
(4, '派车记录', 'paichejilu', '/1/', '', 0, '1', 0, 0, '[\"paicheshuoming\",\"guanliancheliang\",\"guanlianjiashiyuan\",\"paicheshijian\",\"paicheren\",\"shoucheshijian\",\"shoucheren\",\"beizhu\",\"frame_id\",\"paichezhuangtai\"]', '2024-04-29 09:00:09', '2024-04-30 08:55:42', NULL);
-- 转存表中的数据 `eb_system_crud_approve`
INSERT INTO `eb_system_crud_approve` (`id`, `crud_id`, `user_id`, `icon`, `color`, `name`, `info`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 3, 1, 'iconjiaoche', '#FF9900', '用车申请', '适用于所有员工的用车申请。', 1, '2024-04-30 01:51:42', '2024-04-30 01:53:25', NULL);
-- 转存表中的数据 `eb_system_crud_approve_process`
INSERT INTO `eb_system_crud_approve_process` (`id`, `user_id`, `approve_id`, `level`, `groups`, `name`, `types`, `uniqued`, `settype`, `director_order`, `director_level`, `no_hander`, `dep_head`, `self_select`, `select_range`, `user_list`, `select_mode`, `examine_mode`, `priority`, `parent`, `is_child`, `is_condition`, `condition_list`, `is_initial`, `info`) VALUES
(1, 1, 1, 0, 0, '申请人', 0, '1515d85470fb44e36', 0, -1, 0, 0, '', 0, 0, '{\"depList\":[],\"userList\":[]}', 0, 0, 0, '', 1, 0, '', 1, '{\"nodeName\":\"\\u7533\\u8bf7\\u4eba\",\"type\":\"0\",\"onlyValue\":\"1515d85470fb44e36\",\"priorityLevel\":\"\",\"settype\":\"\",\"selectMode\":\"\",\"selectRange\":\"\",\"directorLevel\":\"\",\"examineMode\":\"\",\"noHanderAction\":\"\",\"examineEndDirectorLevel\":\"\",\"ccSelfSelectFlag\":\"\",\"conditionList\":[],\"nodeUserList\":{\"depList\":[],\"userList\":[]},\"childNode\":{\"nodeName\":\"\\u5ba1\\u6838\\u4eba\",\"error\":false,\"type\":\"1\",\"onlyValue\":\"13fe42a4ad2bea03f\",\"settype\":\"2\",\"selectMode\":\"0\",\"selectRange\":\"0\",\"directorLevel\":\"1\",\"directorOrder\":\"1\",\"examineMode\":\"3\",\"noHanderAction\":\"1\",\"examineEndDirectorLevel\":\"0\",\"childNode\":{\"nodeName\":\"\\u6284\\u9001\\u4eba\",\"type\":\"2\",\"onlyValue\":\"47bd9ea46408b8ac1\",\"ccSelfSelectFlag\":\"1\",\"departmentHead\":[],\"childNode\":\"\",\"nodeUserList\":[],\"error\":false},\"nodeUserList\":[]},\"conditionNodes\":[]}'),
(2, 1, 1, 1, 0, '审核人', 1, '13fe42a4ad2bea03f', 2, 1, 1, 1, '', 0, 0, '', 0, 3, 0, '1515d85470fb44e36', 1, 0, '', 0, ''),
(3, 1, 1, 2, 0, '抄送人', 2, '47bd9ea46408b8ac1', 0, -1, 0, 0, '', 1, 0, '', 0, 0, 0, '13fe42a4ad2bea03f', 0, 0, '', 0, '');
-- 转存表中的数据 `eb_system_crud_approve_rule`
INSERT INTO `eb_system_crud_approve_rule` (`id`, `user_id`, `approve_id`, `range`, `abnormal`, `auto`, `edit`, `recall`, `refuse`) VALUES (1, 1, 1, '', 0, '0', '[\"1\",\"2\"]', 0, '0');
-- 转存表中的数据 `eb_system_crud_cate`
INSERT INTO `eb_system_crud_cate` (`id`, `name`, `sort`, `created_at`, `updated_at`) VALUES
(1, '车辆管理', 7, '2024-04-29 08:51:53', '2024-05-09 01:43:53');
-- 转存表中的数据 `eb_system_crud_event`
INSERT INTO `eb_system_crud_event` (`id`, `crud_id`, `name`, `event`, `action`, `sort`, `target_crud_id`, `crud_approve_id`, `send_type`, `send_user`, `notify_type`, `additional_search`, `template`, `field_options`, `options`, `created_at`, `updated_at`, `deleted_at`, `status`, `additional_search_boolean`, `aggregate_target_search_boolean`, `aggregate_data_search_boolean`, `aggregate_data_search`, `timer`, `aggregate_target_search`, `aggregate_field_rule`, `aggregate_data_field`) VALUES
(1, 3, '新增用车审批', 'auto_approve', '[\"create\"]', 0, 3, 1, 0, '[]', '[]', '[]', '', '[]', '[]', '2024-04-30 01:55:12', '2024-04-30 01:55:26', NULL, 1, 0, 0, 0, '[]', 0, '[]', '[]', '[]'),
(2, 3, '审批通过自动新增派车记录', 'auto_create', '', 0, 0, 0, 0, '', '', '', '', '', '', '2024-04-30 01:58:26', '2024-04-30 02:00:47', '2024-04-30 02:00:47', 1, 0, 0, 0, '', 0, '', '', ''),
(3, 3, '审批通过自动新增派车记录', 'auto_create', '[\"approve_success\"]', 0, 4, 0, 0, '[]', '[]', '[]', '', '[{\"form_field_uniqid\":\"paichejilu.guanliancheliang\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"shenqingcheliang\"},{\"form_field_uniqid\":\"paichejilu.guanlianjiashiyuan\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"shenqingjiashiyuan\"},{\"form_field_uniqid\":\"paichejilu.paicheshuoming\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"shenqingshiyou\"},{\"form_field_uniqid\":\"paichejilu.beizhu\",\"operator\":\"field_value\",\"to_form_field_uniqid\":\"beizhu\"}]', '[]', '2024-04-30 02:01:24', '2024-04-30 02:02:32', NULL, 1, 0, 0, 0, '[]', 0, '[]', '[]', '[]'),
(4, 3, '车辆被占用', 'data_check', '', 0, 0, 0, 0, '', '', '', '', '', '', '2024-04-30 07:19:33', '2024-04-30 07:21:01', '2024-04-30 07:21:01', 1, 0, 0, 0, '', 0, '', '', '');
-- 转存表中的数据 `eb_system_crud_field`
INSERT INTO `eb_system_crud_field` (`crud_id`, `field_name`, `field_name_en`, `form_value`, `field_type`, `is_default_value_not_null`, `is_table_show_row`, `comment`, `prev_field`, `data_dict_id`, `association_crud_id`, `is_main`, `is_form`, `form_field_uniqid`, `association_field_names`, `options`, `create_modify`, `update_modify`, `is_default`) VALUES
(1, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee39d', '', '', 1, 1, 1),
(1, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3ab', '', '', 1, 1, 1),
(1, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3b2', '', '', 1, 1, 1),
(1, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3b8', '', '', 1, 1, 1),
(1, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3be', '', '', 1, 1, 1),
(1, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'beizhu', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3c4', '', '', 1, 1, 1),
(1, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3d7', '', '', 1, 1, 1),
(1, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'cheliangjichuxinxi662f6134ee3dd', '', '', 1, 1, 1),
(2, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'jiashiyuanxinxi662f618741476', '', '', 1, 1, 1),
(2, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 0, 0, 0, 'jiashiyuanxinxi662f618741487', '', '', 1, 1, 1),
(2, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 0, 0, 0, 'jiashiyuanxinxi662f61874148f', '', '', 1, 1, 1),
(2, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 0, 0, 0, 'jiashiyuanxinxi662f618741496', '', '', 1, 1, 1),
(2, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 0, 0, 0, 'jiashiyuanxinxi662f61874149c', '', '', 1, 1, 1),
(2, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'beizhu', 0, 0, 0, 0, 'jiashiyuanxinxi662f6187414a2', '', '', 1, 1, 1),
(2, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'jiashiyuanxinxi662f6187414a9', '', '', 1, 1, 1),
(2, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'jiashiyuanxinxi662f6187414af', '', '', 1, 1, 1),
(3, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'yongcheshenqing662f61900367f', '', '', 1, 1, 1),
(3, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 0, 0, 0, 'yongcheshenqing662f619003690', '', '', 1, 1, 1),
(3, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 0, 0, 0, 'yongcheshenqing662f619003697', '', '', 1, 1, 1),
(3, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 0, 0, 1, 'yongcheshenqing662f61900369c', '', '', 1, 1, 1),
(3, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 0, 0, 1, 'yongcheshenqing662f6190036a4', '', '', 1, 1, 1),
(3, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'beizhu', 0, 0, 0, 0, 'yongcheshenqing662f6190036ad', '', '', 1, 1, 1),
(3, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'yongcheshenqing662f6190036b7', '', '', 1, 1, 1),
(3, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'yongcheshenqing662f6190036be', '', '', 1, 1, 1),
(4, '主键ID', 'id', 'input_number', 'int', 0, 0, '主键ID', '', 0, 0, 0, 0, 'paichejilu662f619953128', '', '', 1, 1, 1),
(4, '创建用户', 'user_id', 'input_select', 'int', 1, 0, '创建用户', 'id', 0, 0, 0, 0, 'paichejilu662f61995313d', '', '', 1, 1, 1),
(4, '修改用户', 'update_user_id', 'input_select', 'int', 1, 0, '修改用户', 'user_id', 0, 0, 0, 0, 'paichejilu662f619953147', '', '', 1, 1, 1),
(4, '所属部门', 'frame_id', 'input_select', 'int', 1, 0, '所属部门', 'update_user_id', 0, 0, 0, 1, 'paichejilu662f619953150', '', '', 1, 1, 1),
(4, '所属用户', 'owner_user_id', 'input_select', 'int', 1, 0, '所属用户', 'frame_id', 0, 0, 0, 0, 'paichejilu662f619953158', '', '', 1, 1, 1),
(4, '创建时间', 'created_at', 'date_time_picker', 'timestamp', 1, 0, '创建时间', 'paichezhuangtai', 0, 0, 0, 0, 'paichejilu662f619953161', '', '', 1, 1, 1),
(4, '修改时间', 'updated_at', 'date_time_picker', 'timestamp', 1, 0, '修改时间', 'created_at', 0, 0, 0, 0, 'paichejilu662f61995316a', '', '', 1, 1, 1),
(4, '伪删除', 'deleted_at', 'date_time_picker', 'timestamp', 1, 0, '伪删除', 'updated_at', 0, 0, 0, 0, 'paichejilu662f619953172', '', '', 1, 1, 1),
(1, '车牌号', 'chepaihao', 'input', 'varchar', 0, 1, '车牌号', 'owner_user_id', 0, 0, 1, 1, 'cheliangjichuxinxi662f6268242f7', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(1, '车辆类型', 'cheliangleixing', 'radio', 'int', 0, 1, '车辆类型', 'chepaihao', 37, 0, 0, 1, 'cheliangjichuxinxi662f63237d255', '[]', '[]', 1, 1, 0),
(1, '厂牌型号', 'changpaixinghao', 'input', 'varchar', 0, 1, '厂牌型号', 'cheliangleixing', 0, 0, 0, 1, 'cheliangjichuxinxi662f6335ab878', '[]', '{\"maxlength\":\"64\"}', 1, 1, 0),
(1, '购买价格', 'goumaijiage', 'input_price', 'decimal', 0, 1, '购买价格', 'changpaixinghao', 0, 0, 0, 1, 'cheliangjichuxinxi662f634e7d8f3', '[]', '{\"max\":\"999999999\",\"precision\":\"2\",\"min\":\"1\"}', 1, 1, 0),
(1, '购置日期', 'gouzhiriqi', 'date_picker', 'date', 0, 1, '购置日期', 'goumaijiage', 0, 0, 0, 1, 'cheliangjichuxinxi662f637271cff', '[]', '[]', 1, 1, 0),
(1, '发动机编号', 'fadongjibianhao', 'input', 'varchar', 0, 1, '发动机编号', 'gouzhiriqi', 0, 0, 0, 1, 'cheliangjichuxinxi662f6387d0624', '[]', '{\"maxlength\":\"128\"}', 1, 1, 0),
(1, '车辆图片', 'cheliangtupian', 'image', 'text', 1, 1, '车辆图片', 'fadongjibianhao', 0, 0, 0, 1, 'cheliangjichuxinxi662f639c8cca4', '[]', '{\"max\":\"3\",\"size\":\"5\"}', 1, 1, 0),
(1, '备注', 'beizhu', 'textarea', 'text', 1, 1, '备注', 'cheliangtupian', 0, 0, 0, 0, 'cheliangjichuxinxi662f63b2e9ae4', '[]', '{\"rows\":\"4\",\"maxlength\":\"200\"}', 1, 1, 0),
(2, '关联车辆', 'guanliancheliang', 'input_select', 'int', 0, 1, '关联车辆', 'owner_user_id', 0, 136, 0, 0, 'jiashiyuanxinxi662f657ad3d6e', '[\"id\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\"]', '[]', 1, 1, 0),
(2, '驾驶员姓名', 'jiashiyuanxingming', 'input', 'varchar', 0, 1, '驾驶员姓名', 'deleted_at', 0, 0, 1, 0, 'jiashiyuanxinxi662f6596e4607', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(2, '联系电话', 'lianxidianhua', 'input', 'varchar', 0, 1, '联系电话', 'jiashiyuanxingming', 0, 0, 0, 1, 'jiashiyuanxinxi662f65df3237a', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(2, '驾照类型', 'jiazhaoleixing', 'radio', 'int', 0, 1, '驾照类型', 'lianxidianhua', 39, 0, 0, 1, 'jiashiyuanxinxi662f6633568ea', '[]', '[]', 1, 1, 0),
(2, '驾照编号', 'jiazhaobianhao', 'input', 'varchar', 0, 1, '驾照编号', 'jiazhaoleixing', 0, 0, 0, 1, 'jiashiyuanxinxi662f66421cac5', '[]', '{\"maxlength\":\"64\"}', 1, 1, 0),
(2, '驾照到期时间', 'jiazhaodaoqishijian', 'date_picker', 'date', 0, 1, '驾照到期时间', 'jiazhaobianhao', 0, 0, 0, 1, 'jiashiyuanxinxi662f664f278bd', '[]', '[]', 1, 1, 0),
(2, '备注', 'beizhu', 'textarea', 'text', 1, 1, '备注', 'jiazhaodaoqishijian', 0, 0, 0, 1, 'jiashiyuanxinxi662f665986164', '[]', '{\"maxlength\":\"200\",\"rows\":\"4\"}', 1, 1, 0),
(3, '申请车辆', 'shenqingcheliang', 'input_select', 'int', 0, 1, '申请车辆', 'owner_user_id', 0, 136, 0, 1, 'yongcheshenqing662f669dc7874', '[\"id\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\"]', '[]', 1, 1, 0),
(3, '申请驾驶员', 'shenqingjiashiyuan', 'input_select', 'int', 0, 1, '申请驾驶员', 'shenqingcheliang', 0, 137, 0, 1, 'yongcheshenqing662f66bc90d23', '[\"id\",\"jiashiyuanxingming\",\"lianxidianhua\",\"jiazhaoleixing\"]', '[]', 1, 1, 0),
(3, '开始时间', 'kaishishijian', 'date_time_picker', 'timestamp', 0, 1, '开始时间', 'shenqingjiashiyuan', 0, 0, 0, 1, 'yongcheshenqing662f66c8b8378', '[]', '[]', 1, 1, 0),
(3, '结束时间', 'jieshushijian', 'date_time_picker', 'timestamp', 0, 1, '结束时间', 'kaishishijian', 0, 0, 0, 1, 'yongcheshenqing662f66d129ea9', '[]', '[]', 1, 1, 0),
(3, '起始位置', 'qishiweizhi', 'input', 'varchar', 0, 1, '起始位置', 'jieshushijian', 0, 0, 0, 1, 'yongcheshenqing662f66e1d9a09', '[]', '{\"minlength\":\"0\",\"maxlength\":\"128\"}', 1, 1, 0),
(3, '申请事由', 'shenqingshiyou', 'input', 'varchar', 0, 1, '申请事由', 'qishiweizhi', 0, 0, 1, 1, 'yongcheshenqing662f6700d9550', '[]', '{\"maxlength\":\"128\"}', 1, 1, 0),
(3, '到达位置', 'daodaweizhi', 'input', 'varchar', 0, 1, '到达位置', 'shenqingshiyou', 0, 0, 0, 1, 'yongcheshenqing662f671b484f7', '[]', '{\"max\":\"1\",\"precision\":\"0\",\"min\":\"1\",\"maxlength\":\"128\"}', 1, 1, 0),
(3, '预计里程', 'yujilicheng', 'input_float', 'decimal', 0, 1, '预计里程', 'daodaweizhi', 0, 0, 0, 1, 'yongcheshenqing662f6735a442b', '[]', '{\"max\":\"999999\",\"precision\":\"2\"}', 1, 1, 0),
(3, '备注', 'beizhu', 'textarea', 'text', 1, 1, '备注', 'yujilicheng', 0, 0, 0, 1, 'yongcheshenqing662f675035b65', '[]', '{\"rows\":\"4\",\"maxlength\":\"200\"}', 1, 1, 0),
(4, '派车说明', 'paicheshuoming', 'input', 'varchar', 0, 1, '派车说明', 'owner_user_id', 0, 0, 1, 1, 'paichejilu662f677a0527e', '[]', '{\"maxlength\":\"128\"}', 1, 1, 0),
(4, '关联车辆', 'guanliancheliang', 'input_select', 'int', 0, 1, '关联车辆', 'paicheshuoming', 0, 136, 0, 1, 'paichejilu662f67f2a3fc5', '[\"id\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\"]', '[]', 1, 1, 0),
(4, '关联驾驶员', 'guanlianjiashiyuan', 'input_select', 'int', 0, 1, '关联驾驶员', 'guanliancheliang', 0, 137, 0, 1, 'paichejilu662f682c282f6', '[\"id\",\"jiashiyuanxingming\",\"lianxidianhua\",\"jiazhaoleixing\"]', '[]', 1, 1, 0),
(4, '派车时间', 'paicheshijian', 'date_time_picker', 'timestamp', 1, 1, '派车时间', 'guanlianjiashiyuan', 0, 0, 0, 1, 'paichejilu662f68a104fd6', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(4, '派车人', 'paicheren', 'input', 'varchar', 1, 1, '派车人', 'paicheshijian', 0, 0, 0, 1, 'paichejilu662f68ac67833', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(4, '收车时间', 'shoucheshijian', 'date_time_picker', 'timestamp', 1, 1, '收车时间', 'paicheren', 0, 0, 0, 1, 'paichejilu662f68ba302d5', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(4, '收车人', 'shoucheren', 'input', 'varchar', 1, 1, '收车人', 'shoucheshijian', 0, 0, 0, 1, 'paichejilu662f68c6cfc24', '[]', '{\"maxlength\":\"16\"}', 1, 1, 0),
(4, '备注', 'beizhu', 'textarea', 'text', 1, 1, '备注', 'shoucheren', 0, 0, 0, 1, 'paichejilu662f68d21b4ec', '[]', '{\"rows\":\"4\",\"maxlength\":\"200\"}', 1, 1, 0),
(4, '关联用车申请', 'guanlianyongcheshenqing', 'input_select', 'int', 0, 1, '关联用车申请', 'beizhu', 0, 138, 0, 0, 'paichejilu663050ae6e375', '[\"id\",\"frame_id\",\"owner_user_id\",\"shenqingcheliang\",\"shenqingjiashiyuan\",\"shenqingshiyou\",\"kaishishijian\",\"jieshushijian\"]', '[]', 1, 1, 0),
(4, '派车状态', 'paichezhuangtai', 'radio', 'int', 0, 1, '派车状态', 'guanlianyongcheshenqing', 40, 0, 0, 1, 'paichejilu66308c11d9959', '[]', '[]', 1, 1, 0);
-- 转存表中的数据 `eb_system_crud_form`
INSERT INTO `eb_system_crud_form` (`id`, `crud_id`, `version`, `options`, `fields`, `global_options`, `is_index`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 1, 1, '[{\"name\":\"\\u8f66\\u724c\\u53f7\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"chepaihao\",\"label\":\"\\u8f66\\u724c\\u53f7\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u8f66\\u724c\\u53f7\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"16\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1579\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"chepaihao\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input89450\",\"i\":\"6\",\"pidx\":\"0\"},{\"name\":\"\\u5382\\u724c\\u578b\\u53f7\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"changpaixinghao\",\"label\":\"\\u5382\\u724c\\u578b\\u53f7\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u5382\\u724c\\u578b\\u53f7\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"64\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1581\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"changpaixinghao\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input74758\",\"i\":\"8\",\"pidx\":\"0\"},{\"name\":\"\\u8d2d\\u4e70\\u4ef7\\u683c\",\"type\":\"input-price\",\"icon\":\"number-field\",\"formItemFlag\":true,\"options\":{\"name\":\"goumaijiage\",\"label\":\"\\u8d2d\\u4e70\\u4ef7\\u683c\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u8d2d\\u4e70\\u4ef7\\u683c\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1582\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"keyNameEnabled\":false,\"keyName\":\"\",\"min\":\"1\",\"max\":\"999999999\",\"precision\":\"0\",\"step\":\"1\",\"formFieldUniqid\":\"goumaijiage\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputprice99735\",\"i\":\"9\",\"pidx\":\"0\"},{\"name\":\"\\u8d2d\\u7f6e\\u65e5\\u671f\",\"type\":\"date-picker\",\"icon\":\"date-field\",\"formItemFlag\":true,\"options\":{\"name\":\"gouzhiriqi\",\"label\":\"\\u8d2d\\u7f6e\\u65e5\\u671f\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u9009\\u62e9\\u8d2d\\u7f6e\\u65e5\\u671f\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1583\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":true,\"format\":\"yyyy-MM-dd\",\"valueFormat\":\"yyyy-MM-dd\",\"formFieldUniqid\":\"gouzhiriqi\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"datepicker82009\",\"i\":\"10\",\"pidx\":\"0\"},{\"name\":\"\\u53d1\\u52a8\\u673a\\u7f16\\u53f7\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"fadongjibianhao\",\"label\":\"\\u53d1\\u52a8\\u673a\\u7f16\\u53f7\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u53d1\\u52a8\\u673a\\u7f16\\u53f7\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"128\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1584\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"fadongjibianhao\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input84046\",\"i\":\"11\",\"pidx\":\"0\"},{\"name\":\"\\u8f66\\u8f86\\u7c7b\\u578b\",\"type\":\"radio\",\"icon\":\"radio-field\",\"formItemFlag\":true,\"options\":{\"name\":\"cheliangleixing\",\"label\":\"\\u8f66\\u8f86\\u7c7b\\u578b\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"1\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"37\",\"fieldId\":\"1580\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"displayStyle\":\"inline\",\"buttonStyle\":false,\"border\":false,\"optionItems\":[{\"id\":\"4301\",\"name\":\"\\u5c0f\\u8f7f\\u8f66\",\"value\":\"1\",\"type_id\":\"37\",\"pid\":\"\",\"type_name\":\"cheliangleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:04:51\",\"updated_at\":\"2024-04-29 17:04:51\"},{\"id\":\"4302\",\"name\":\"\\u5546\\u52a1\\u8f66\",\"value\":\"2\",\"type_id\":\"37\",\"pid\":\"\",\"type_name\":\"cheliangleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:05:13\",\"updated_at\":\"2024-04-29 17:05:13\"},{\"id\":\"4303\",\"name\":\"\\u4e2d\\u5df4\",\"value\":\"3\",\"type_id\":\"37\",\"pid\":\"\",\"type_name\":\"cheliangleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:05:19\",\"updated_at\":\"2024-04-29 17:05:19\"},{\"id\":\"4304\",\"name\":\"\\u5927\\u5df4\",\"value\":\"4\",\"type_id\":\"37\",\"pid\":\"\",\"type_name\":\"cheliangleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:05:40\",\"updated_at\":\"2024-04-29 17:37:12\"}],\"formFieldUniqid\":\"cheliangleixing\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"radio53988\",\"i\":\"7\",\"pidx\":\"0\"},{\"name\":\"\\u8f66\\u8f86\\u56fe\\u7247\",\"type\":\"image\",\"icon\":\"picture-upload-field\",\"formItemFlag\":true,\"options\":{\"name\":\"cheliangtupian\",\"label\":\"\\u8f66\\u8f86\\u56fe\\u7247\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":[],\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1585\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"uploadURL\":\"Common\\/upload\",\"uploadTip\":\"\",\"withCredentials\":false,\"multipleSelect\":false,\"showFileList\":false,\"limit\":\"3\",\"fileMaxSize\":\"5\",\"fileTypes\":[\"jpg\",\"jpeg\",\"png\",\"gif\"],\"formFieldUniqid\":\"cheliangtupian\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"image22452\",\"i\":\"12\",\"pidx\":\"0\"},{\"name\":\"\\u5907\\u6ce8\",\"type\":\"textarea\",\"icon\":\"textarea-field\",\"formItemFlag\":true,\"options\":{\"name\":\"beizhu\",\"label\":\"\\u5907\\u6ce8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u586b\\u5199\\u5907\\u6ce8\\u4fe1\\u606f\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"200\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1586\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"rows\":\"4\",\"formFieldUniqid\":\"beizhu\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"textarea42208\",\"i\":\"13\",\"pidx\":\"0\"}]', '[\"chepaihao\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\",\"goumaijiage\",\"gouzhiriqi\",\"fadongjibianhao\",\"cheliangtupian\",\"chepaihao\",\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\",\"goumaijiage\",\"gouzhiriqi\"]', '{\"modelName\":\"formData\",\"refName\":\"vForm\",\"rulesName\":\"rules\",\"labelWidth\":\"90\",\"labelPosition\":\"left\",\"size\":\"small\",\"labelAlign\":\"label-right-align\",\"cssCode\":\"\",\"customClass\":[],\"functions\":\"\",\"layoutType\":\"PC\",\"onFormCreated\":\"\",\"onFormMounted\":\"\",\"onFormDataChange\":\"\"}', 1, '2024-04-29 10:20:59', '2024-04-29 10:20:59', NULL),
(2, 2, 1, '[{\"name\":\"\\u9a7e\\u9a76\\u5458\\u59d3\\u540d\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"jiashiyuanxingming\",\"label\":\"\\u9a7e\\u9a76\\u5458\\u59d3\\u540d\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u9a7e\\u9a76\\u5458\\u59d3\\u540d\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"16\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1596\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"jiashiyuanxingming\",\"isCityShow\":\"\"},\"hide\":true,\"id\":\"input73234\",\"i\":\"7\",\"pidx\":\"0\"},{\"name\":\"\\u8054\\u7cfb\\u7535\\u8bdd\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"lianxidianhua\",\"label\":\"\\u8054\\u7cfb\\u7535\\u8bdd\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u8054\\u7cfb\\u7535\\u8bdd\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"16\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1597\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"lianxidianhua\",\"isCityShow\":\"\"},\"hide\":true,\"id\":\"input72454\",\"i\":\"8\",\"pidx\":\"0\"},{\"name\":\"\\u9a7e\\u7167\\u7c7b\\u578b\",\"type\":\"radio\",\"icon\":\"radio-field\",\"formItemFlag\":true,\"options\":{\"name\":\"jiazhaoleixing\",\"label\":\"\\u9a7e\\u7167\\u7c7b\\u578b\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"1\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"39\",\"fieldId\":\"1598\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"displayStyle\":\"inline\",\"buttonStyle\":false,\"border\":false,\"optionItems\":[{\"id\":\"4311\",\"name\":\"C1\",\"value\":\"1\",\"type_id\":\"39\",\"pid\":\"\",\"type_name\":\"jiazhaoleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:19:06\",\"updated_at\":\"2024-04-29 17:19:06\"},{\"id\":\"4312\",\"name\":\"C2\",\"value\":\"2\",\"type_id\":\"39\",\"pid\":\"\",\"type_name\":\"jiazhaoleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:19:12\",\"updated_at\":\"2024-04-29 17:19:12\"},{\"id\":\"4313\",\"name\":\"B1\",\"value\":\"3\",\"type_id\":\"39\",\"pid\":\"\",\"type_name\":\"jiazhaoleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:19:17\",\"updated_at\":\"2024-04-29 17:19:17\"},{\"id\":\"4314\",\"name\":\"B2\",\"value\":\"4\",\"type_id\":\"39\",\"pid\":\"\",\"type_name\":\"jiazhaoleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:19:21\",\"updated_at\":\"2024-04-29 17:19:21\"},{\"id\":\"4315\",\"name\":\"A1\",\"value\":\"5\",\"type_id\":\"39\",\"pid\":\"\",\"type_name\":\"jiazhaoleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:19:26\",\"updated_at\":\"2024-04-29 17:19:26\"},{\"id\":\"4316\",\"name\":\"A2\",\"value\":\"6\",\"type_id\":\"39\",\"pid\":\"\",\"type_name\":\"jiazhaoleixing\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-29 17:19:32\",\"updated_at\":\"2024-04-29 17:19:32\"}],\"formFieldUniqid\":\"jiazhaoleixing\",\"isCityShow\":\"\"},\"hide\":true,\"id\":\"radio30811\",\"i\":\"9\",\"pidx\":\"0\"},{\"name\":\"\\u9a7e\\u7167\\u7f16\\u53f7\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"jiazhaobianhao\",\"label\":\"\\u9a7e\\u7167\\u7f16\\u53f7\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u9a7e\\u7167\\u7f16\\u53f7\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"64\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1599\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"jiazhaobianhao\",\"isCityShow\":\"\"},\"hide\":true,\"id\":\"input23430\",\"i\":\"10\",\"pidx\":\"0\"},{\"name\":\"\\u9a7e\\u7167\\u5230\\u671f\\u65f6\\u95f4\",\"type\":\"date-picker\",\"icon\":\"date-field\",\"formItemFlag\":true,\"options\":{\"name\":\"jiazhaodaoqishijian\",\"label\":\"\\u9a7e\\u7167\\u5230\\u671f\\u65f6\\u95f4\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u9009\\u62e9\\u9a7e\\u7167\\u5230\\u671f\\u65f6\\u95f4\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1600\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":false,\"format\":\"yyyy-MM-dd\",\"valueFormat\":\"yyyy-MM-dd\",\"formFieldUniqid\":\"jiazhaodaoqishijian\",\"isCityShow\":\"\"},\"hide\":true,\"id\":\"datepicker62490\",\"i\":\"11\",\"pidx\":\"0\"},{\"name\":\"\\u5907\\u6ce8\",\"type\":\"textarea\",\"icon\":\"textarea-field\",\"formItemFlag\":true,\"options\":{\"name\":\"beizhu\",\"label\":\"\\u5907\\u6ce8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u586b\\u5199\\u5907\\u6ce8\\u4fe1\\u606f\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"200\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1601\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"rows\":\"4\",\"formFieldUniqid\":\"beizhu\",\"isCityShow\":\"\"},\"hide\":true,\"id\":\"textarea51907\",\"i\":\"12\",\"pidx\":\"0\"}]', '[\"jiashiyuanxingming\",\"lianxidianhua\",\"jiazhaoleixing\",\"jiazhaobianhao\",\"jiazhaodaoqishijian\",\"beizhu\",\"jiashiyuanxingming\",\"lianxidianhua\",\"jiashiyuanxingming\"]', '{\"modelName\":\"formData\",\"refName\":\"vForm\",\"rulesName\":\"rules\",\"labelWidth\":\"100\",\"labelPosition\":\"left\",\"size\":\"small\",\"labelAlign\":\"label-right-align\",\"cssCode\":\"\",\"customClass\":[],\"functions\":\"\",\"layoutType\":\"PC\",\"onFormCreated\":\"\",\"onFormMounted\":\"\",\"onFormDataChange\":\"\"}', 1, '2024-04-29 10:21:20', '2024-04-29 10:21:20', NULL),
(3, 3, 1, '[{\"name\":\"\\u7533\\u8bf7\\u4e8b\\u7531\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"shenqingshiyou\",\"label\":\"\\u7533\\u8bf7\\u4e8b\\u7531\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u7533\\u8bf7\\u4e8b\\u7531\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"128\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1607\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"shenqingshiyou\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input98027\",\"i\":\"11\",\"pidx\":\"0\"},{\"name\":\"\\u6240\\u5c5e\\u90e8\\u95e8\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"frame_id\",\"label\":\"\\u7533\\u8bf7\\u90e8\\u95e8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u7533\\u8bf7\\u90e8\\u95e8\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1566\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"frame_id\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect73983\",\"i\":\"2\",\"pidx\":\"0\"},{\"name\":\"\\u6240\\u5c5e\\u7528\\u6237\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"owner_user_id\",\"label\":\"\\u7533\\u8bf7\\u7528\\u6237\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u7533\\u8bf7\\u7528\\u6237\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1567\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"owner_user_id\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect53923\",\"i\":\"3\",\"pidx\":\"0\"},{\"name\":\"\\u7533\\u8bf7\\u8f66\\u8f86\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"shenqingcheliang\",\"label\":\"\\u7533\\u8bf7\\u8f66\\u8f86\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u7533\\u8bf7\\u8f66\\u8f86\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1602\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"shenqingcheliang\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect69323\",\"i\":\"6\",\"pidx\":\"0\"},{\"name\":\"\\u7533\\u8bf7\\u9a7e\\u9a76\\u5458\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"shenqingjiashiyuan\",\"label\":\"\\u7533\\u8bf7\\u9a7e\\u9a76\\u5458\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u7533\\u8bf7\\u9a7e\\u9a76\\u5458\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1603\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"shenqingjiashiyuan\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect29348\",\"i\":\"7\",\"pidx\":\"0\"},{\"name\":\"\\u5f00\\u59cb\\u65f6\\u95f4\",\"type\":\"date-time-picker\",\"icon\":\"date-range-field\",\"formItemFlag\":true,\"options\":{\"name\":\"kaishishijian\",\"label\":\"\\u5f00\\u59cb\\u65f6\\u95f4\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5f00\\u59cb\\u65f6\\u95f4\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1604\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":true,\"format\":\"yyyy-MM-dd HH:mm:ss\",\"valueFormat\":\"yyyy-MM-dd HH:mm:ss\",\"formFieldUniqid\":\"kaishishijian\",\"startPlaceholder\":\"\\u8bf7\\u9009\\u62e9\\u5f00\\u59cb\\u65f6\\u95f4\",\"endPlaceholder\":\"\\u8bf7\\u9009\\u62e9\\u5f00\\u59cb\\u65f6\\u95f4\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"datetimepicker82319\",\"i\":\"8\",\"pidx\":\"0\"},{\"name\":\"\\u7ed3\\u675f\\u65f6\\u95f4\",\"type\":\"date-time-picker\",\"icon\":\"date-range-field\",\"formItemFlag\":true,\"options\":{\"name\":\"jieshushijian\",\"label\":\"\\u7ed3\\u675f\\u65f6\\u95f4\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u7ed3\\u675f\\u65f6\\u95f4\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1605\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":true,\"format\":\"yyyy-MM-dd HH:mm:ss\",\"valueFormat\":\"yyyy-MM-dd HH:mm:ss\",\"formFieldUniqid\":\"jieshushijian\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"datetimepicker63724\",\"i\":\"9\",\"pidx\":\"0\"},{\"name\":\"\\u8d77\\u59cb\\u4f4d\\u7f6e\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"qishiweizhi\",\"label\":\"\\u8d77\\u59cb\\u4f4d\\u7f6e\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u8d77\\u59cb\\u4f4d\\u7f6e\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"0\",\"maxLength\":\"128\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1606\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"qishiweizhi\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input79346\",\"i\":\"10\",\"pidx\":\"0\"},{\"name\":\"\\u5230\\u8fbe\\u4f4d\\u7f6e\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"daodaweizhi\",\"label\":\"\\u5230\\u8fbe\\u4f4d\\u7f6e\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u5230\\u8fbe\\u4f4d\\u7f6e\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"128\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1608\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"daodaweizhi\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input49962\",\"i\":\"12\",\"pidx\":\"0\"},{\"name\":\"\\u9884\\u8ba1\\u91cc\\u7a0b\",\"type\":\"input-float\",\"icon\":\"number-field\",\"formItemFlag\":true,\"options\":{\"name\":\"yujilicheng\",\"label\":\"\\u9884\\u8ba1\\u91cc\\u7a0b\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u9884\\u8ba1\\u91cc\\u7a0b\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1609\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"keyNameEnabled\":false,\"keyName\":\"\",\"min\":\"-999999999\",\"max\":\"999999999\",\"precision\":\"2\",\"step\":\"1\",\"formFieldUniqid\":\"yujilicheng\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputfloat26790\",\"i\":\"13\",\"pidx\":\"0\"},{\"name\":\"\\u5907\\u6ce8\",\"type\":\"textarea\",\"icon\":\"textarea-field\",\"formItemFlag\":true,\"options\":{\"name\":\"beizhu\",\"label\":\"\\u5907\\u6ce8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u586b\\u5199\\u5907\\u6ce8\\u4fe1\\u606f\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"200\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1610\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"rows\":\"4\",\"formFieldUniqid\":\"beizhu\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"textarea52782\",\"i\":\"14\",\"pidx\":\"0\"}]', '[\"shenqingshiyou\",\"frame_id\",\"owner_user_id\",\"shenqingcheliang\",\"shenqingjiashiyuan\",\"kaishishijian\",\"jieshushijian\",\"qishiweizhi\",\"daodaweizhi\",\"yujilicheng\",\"beizhu\"]', '{\"modelName\":\"formData\",\"refName\":\"vForm\",\"rulesName\":\"rules\",\"labelWidth\":\"90\",\"labelPosition\":\"left\",\"size\":\"small\",\"labelAlign\":\"label-right-align\",\"cssCode\":\"\",\"customClass\":[],\"functions\":\"\",\"layoutType\":\"PC\",\"onFormCreated\":\"\",\"onFormMounted\":\"\",\"onFormDataChange\":\"\"}', 1, '2024-04-30 08:56:18', '2024-04-30 08:56:18', NULL),
(4, 4, 1, '[{\"name\":\"\\u6240\\u5c5e\\u90e8\\u95e8\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"frame_id\",\"label\":\"\\u6240\\u5c5e\\u90e8\\u95e8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1574\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"frame_id\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect31306\",\"i\":\"2\",\"pidx\":\"0\"},{\"name\":\"\\u6d3e\\u8f66\\u8bf4\\u660e\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"paicheshuoming\",\"label\":\"\\u6d3e\\u8f66\\u8bf4\\u660e\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u6d3e\\u8f66\\u8bf4\\u660e\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"128\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1611\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"paicheshuoming\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input37317\",\"i\":\"6\",\"pidx\":\"0\"},{\"name\":\"\\u5173\\u8054\\u8f66\\u8f86\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"guanliancheliang\",\"label\":\"\\u5173\\u8054\\u8f66\\u8f86\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5173\\u8054\\u8f66\\u8f86\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1612\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"guanliancheliang\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect58937\",\"i\":\"7\",\"pidx\":\"0\"},{\"name\":\"\\u5173\\u8054\\u9a7e\\u9a76\\u5458\",\"type\":\"input-select\",\"icon\":\"reference-field\",\"formItemFlag\":true,\"options\":{\"name\":\"guanlianjiashiyuan\",\"label\":\"\\u5173\\u8054\\u9a7e\\u9a76\\u5458\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5173\\u8054\\u9a7e\\u9a76\\u5458\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1613\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"buttonText\":\"\\u9009\\u62e9\",\"formFieldUniqid\":\"guanlianjiashiyuan\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"inputselect29081\",\"i\":\"8\",\"pidx\":\"0\"},{\"name\":\"\\u6d3e\\u8f66\\u72b6\\u6001\",\"type\":\"radio\",\"icon\":\"radio-field\",\"formItemFlag\":true,\"options\":{\"name\":\"paichezhuangtai\",\"label\":\"\\u6d3e\\u8f66\\u72b6\\u6001\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"1\",\"placeholder\":\"\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":true,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"40\",\"fieldId\":\"1620\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"displayStyle\":\"inline\",\"buttonStyle\":false,\"border\":false,\"optionItems\":[{\"id\":\"4317\",\"name\":\"\\u672a\\u5b8c\\u6210\",\"value\":\"1\",\"type_id\":\"40\",\"pid\":\"\",\"type_name\":\"paichezhuanggtai\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-30 14:13:09\",\"updated_at\":\"2024-04-30 14:13:09\"},{\"id\":\"4318\",\"name\":\"\\u5df2\\u5b8c\\u6210\",\"value\":\"2\",\"type_id\":\"40\",\"pid\":\"\",\"type_name\":\"paichezhuanggtai\",\"sort\":\"0\",\"status\":\"1\",\"is_default\":\"0\",\"level\":\"1\",\"mark\":\"\",\"created_at\":\"2024-04-30 14:13:15\",\"updated_at\":\"2024-04-30 14:13:15\"}],\"formFieldUniqid\":\"paichezhuangtai\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"radio106053\",\"i\":\"15\",\"pidx\":\"0\"},{\"name\":\"\\u6d3e\\u8f66\\u65f6\\u95f4\",\"type\":\"date-time-picker\",\"icon\":\"date-range-field\",\"formItemFlag\":true,\"options\":{\"name\":\"paicheshijian\",\"label\":\"\\u6d3e\\u8f66\\u65f6\\u95f4\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u6d3e\\u8f66\\u65f6\\u95f4\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1614\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":true,\"format\":\"yyyy-MM-dd HH:mm:ss\",\"valueFormat\":\"yyyy-MM-dd HH:mm:ss\",\"formFieldUniqid\":\"paicheshijian\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"datetimepicker58003\",\"i\":\"9\",\"pidx\":\"0\"},{\"name\":\"\\u6d3e\\u8f66\\u4eba\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"paicheren\",\"label\":\"\\u6d3e\\u8f66\\u4eba\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u6d3e\\u8f66\\u4eba\\u59d3\\u540d\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"16\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1615\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"paicheren\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input98585\",\"i\":\"10\",\"pidx\":\"0\"},{\"name\":\"\\u6536\\u8f66\\u65f6\\u95f4\",\"type\":\"date-time-picker\",\"icon\":\"date-range-field\",\"formItemFlag\":true,\"options\":{\"name\":\"shoucheshijian\",\"label\":\"\\u6536\\u8f66\\u65f6\\u95f4\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u6d3e\\u8f66\\u65f6\\u95f4\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"300\",\"showWordLimit\":false,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1616\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"editable\":true,\"format\":\"yyyy-MM-dd HH:mm:ss\",\"valueFormat\":\"yyyy-MM-dd HH:mm:ss\",\"formFieldUniqid\":\"shoucheshijian\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"datetimepicker69765\",\"i\":\"11\",\"pidx\":\"0\"},{\"name\":\"\\u6536\\u8f66\\u4eba\",\"type\":\"input\",\"icon\":\"text-field\",\"formItemFlag\":true,\"options\":{\"name\":\"shoucheren\",\"label\":\"\\u6536\\u8f66\\u4eba\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u6536\\u8f66\\u4eba\\u59d3\\u540d\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":true,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"16\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1617\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"formFieldUniqid\":\"shoucheren\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"input63699\",\"i\":\"12\",\"pidx\":\"0\"},{\"name\":\"\\u5907\\u6ce8\",\"type\":\"textarea\",\"icon\":\"textarea-field\",\"formItemFlag\":true,\"options\":{\"name\":\"beizhu\",\"label\":\"\\u5907\\u6ce8\",\"labelAlign\":\"\",\"type\":\"\",\"defaultValue\":\"\",\"placeholder\":\"\\u586b\\u5199\\u5907\\u6ce8\",\"columnWidth\":\"200px\",\"size\":\"\",\"labelWidth\":\"\",\"labelHidden\":false,\"readonly\":false,\"disabled\":false,\"hidden\":false,\"clearable\":false,\"showPassword\":false,\"required\":false,\"requiredHint\":\"\",\"validation\":\"\",\"validationHint\":\"\",\"customClass\":\"\",\"labelIconClass\":\"\",\"labelIconPosition\":\"rear\",\"labelTooltip\":\"\",\"minLength\":\"300\",\"maxLength\":\"200\",\"showWordLimit\":true,\"prefixIcon\":\"\",\"suffixIcon\":\"\",\"appendButton\":false,\"appendButtonDisabled\":false,\"buttonIcon\":\"\",\"dataDictId\":\"0\",\"fieldId\":\"1618\",\"onCreated\":\"\",\"onMounted\":\"\",\"onInput\":\"\",\"onChange\":\"\",\"onFocus\":\"\",\"onBlur\":\"\",\"onValidate\":\"\",\"onAppendButtonClick\":\"\",\"rows\":\"4\",\"formFieldUniqid\":\"beizhu\",\"isCityShow\":\"\"},\"hide\":false,\"id\":\"textarea44244\",\"i\":\"13\",\"pidx\":\"0\"}]', '[\"paicheshuoming\",\"guanliancheliang\",\"guanlianjiashiyuan\",\"paicheshijian\",\"paicheren\",\"shoucheshijian\",\"shoucheren\",\"beizhu\",\"frame_id\",\"paichezhuangtai\"]', '{\"modelName\":\"formData\",\"refName\":\"vForm\",\"rulesName\":\"rules\",\"labelWidth\":\"90\",\"labelPosition\":\"left\",\"size\":\"small\",\"labelAlign\":\"label-right-align\",\"cssCode\":\"\",\"customClass\":[],\"functions\":\"\",\"layoutType\":\"PC\",\"onFormCreated\":\"\",\"onFormMounted\":\"\",\"onFormDataChange\":\"\"}', 1, '2024-04-30 08:55:42', '2024-04-30 08:55:42', NULL);
-- 转存表中的数据 `eb_system_crud_role`
INSERT INTO `eb_system_crud_role` (`id`, `role_id`, `crud_id`, `crud_name`, `created`, `reade`, `reade_frame`, `updated`, `updated_frame`, `deleted`, `deleted_frame`, `created_at`, `updated_at`) VALUES
(1, 1, 1, '', 1, 4, '[]', 4, '[]', 4, '[]', NULL, NULL),
(2, 1, 2, '', 1, 4, '[]', 4, '[]', 4, '[]', NULL, NULL),
(3, 1, 3, '', 1, 4, '[]', 4, '[]', 4, '[]', NULL, NULL),
(4, 1, 4, '', 1, 4, '[]', 4, '[]', 4, '[]', NULL, NULL);
-- 转存表中的数据 `eb_system_crud_table`
INSERT INTO `eb_system_crud_table` (`id`, `crud_id`, `version`, `view_search`, `show_field`, `senior_search`, `options`, `is_index`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 1, 1, 'null', '[\"chepaihao\",\"cheliangleixing\",\"changpaixinghao\",\"goumaijiage\",\"gouzhiriqi\",\"fadongjibianhao\",\"cheliangtupian\"]', '[\"cheliangleixing\",\"goumaijiage\"]', '{\"tab\":[{\"id\":\"2\",\"table_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\",\"table_name_en\":\"jiashiyuanxinxi\",\"field_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\"},{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}],\"create\":[]}', 1, '2024-05-07 09:16:26', '2024-05-07 09:16:26', NULL),
(2, 2, 1, 'null', '[\"jiashiyuanxingming\",\"lianxidianhua\",\"jiazhaoleixing\",\"jiazhaobianhao\",\"jiazhaodaoqishijian\"]', '[\"jiashiyuanxingming\",\"lianxidianhua\"]', '{\"create\":[],\"tab\":[]}', 1, '2024-04-29 10:15:55', '2024-04-29 10:15:55', NULL),
(3, 3, 1, 'null', '[\"shenqingcheliang\",\"shenqingjiashiyuan\",\"kaishishijian\",\"jieshushijian\",\"qishiweizhi\",\"shenqingshiyou\",\"daodaweizhi\",\"yujilicheng\"]', '[\"shenqingjiashiyuan\"]', '{\"create\":[],\"tab\":[]}', 1, '2024-05-06 02:49:49', '2024-05-06 02:49:49', NULL),
(4, 4, 1, 'null', '[\"paicheshuoming\",\"guanliancheliang\",\"guanlianjiashiyuan\",\"paicheshijian\",\"paicheren\",\"shoucheshijian\",\"shoucheren\",\"guanlianyongcheshenqing\",\"paichezhuangtai\"]', 'null', 'null', 1, '2024-04-30 06:31:28', '2024-04-30 06:31:28', NULL);
-- 转存表中的数据 `eb_system_crud_table_user`
INSERT INTO `eb_system_crud_table_user` (`id`, `crud_id`, `user_id`, `senior_search`, `show_field`, `options`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 1, 1, '[\"goumaijiage\",\"updated_at\"]', '[]', '{\"tab\":[{\"id\":\"2\",\"table_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\",\"table_name_en\":\"jiashiyuanxinxi\",\"field_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\"},{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}]}', '2024-04-30 03:40:42', '2024-05-09 02:32:59', NULL),
(2, 1, 1, '[]', '[]', '{\"tab\":[{\"id\":\"2\",\"table_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\",\"table_name_en\":\"jiashiyuanxinxi\",\"field_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\"},{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}],\"create\":[]}', '2024-04-30 03:56:38', '2024-04-30 03:57:47', NULL),
(3, 1, 1, '[]', '[]', '{\"tab\":[{\"id\":\"2\",\"table_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\",\"table_name_en\":\"jiashiyuanxinxi\",\"field_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\"},{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}],\"create\":[{\"id\":\"2\",\"table_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\",\"table_name_en\":\"jiashiyuanxinxi\",\"field_name\":\"\\u9a7e\\u9a76\\u5458\\u4fe1\\u606f\"},{\"id\":\"3\",\"table_name\":\"\\u7528\\u8f66\\u7533\\u8bf7\",\"table_name_en\":\"yongcheshenqing\",\"field_name\":\"\\u7528\\u8f66\\u7533\\u8bf7\"},{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}]}', '2024-04-30 07:00:27', '2024-04-30 08:37:28', NULL),
(4, 3, 1, '[]', '[]', '{\"tab\":[{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}]}', '2024-04-30 07:08:09', '2024-04-30 07:08:09', NULL),
(5, 2, 1, '[]', '[\"jiashiyuanxingming\",\"lianxidianhua\",\"jiazhaoleixing\",\"jiazhaobianhao\",\"jiazhaodaoqishijian\",\"owner_user_id\"]', '{\"create\":[],\"tab\":[{\"id\":\"3\",\"table_name\":\"\\u7528\\u8f66\\u7533\\u8bf7\",\"table_name_en\":\"yongcheshenqing\",\"field_name\":\"\\u7528\\u8f66\\u7533\\u8bf7\"},{\"id\":\"4\",\"table_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\",\"table_name_en\":\"paichejilu\",\"field_name\":\"\\u6d3e\\u8f66\\u8bb0\\u5f55\"}]}', '2024-05-06 06:40:13', '2024-05-07 01:30:32', NULL);
-- 表的结构 `eb_yongcheshenqing`
CREATE TABLE `eb_yongcheshenqing` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '创建用户id',
  `update_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '修改用户id',
  `owner_user_id` int(11) NOT NULL DEFAULT '0' COMMENT '所属用户id',
  `shenqingcheliang` int(11) NOT NULL DEFAULT '0' COMMENT '申请车辆',
  `shenqingjiashiyuan` int(11) NOT NULL DEFAULT '0' COMMENT '申请驾驶员',
  `kaishishijian` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '开始时间',
  `jieshushijian` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '结束时间',
  `qishiweizhi` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '起始位置',
  `shenqingshiyou` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '申请事由',
  `daodaweizhi` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '到达位置',
  `yujilicheng` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '预计里程',
  `beizhu` text COLLATE utf8mb4_unicode_ci COMMENT '备注',
  `frame_id` int(11) NOT NULL DEFAULT '0' COMMENT '部门ID',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用车申请';
-- 转储表的索引
-- 表的索引 `eb_cheliangjichuxinxi`
ALTER TABLE `eb_cheliangjichuxinxi` ADD PRIMARY KEY (`id`);
ALTER TABLE `eb_cheliangjichuxinxi` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
-- 表的索引 `eb_jiashiyuanxinxi`
ALTER TABLE `eb_jiashiyuanxinxi` ADD PRIMARY KEY (`id`);
ALTER TABLE `eb_jiashiyuanxinxi` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
-- 表的索引 `eb_paichejilu`
ALTER TABLE `eb_paichejilu` ADD PRIMARY KEY (`id`);
ALTER TABLE `eb_paichejilu` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;
-- 表的索引 `eb_yongcheshenqing`
ALTER TABLE `eb_yongcheshenqing` ADD PRIMARY KEY (`id`);
ALTER TABLE `eb_yongcheshenqing` MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=1;

INSERT INTO `eb_openapi_rule` (`id`, `pid`, `name`, `type`, `crud_id`, `method`, `url`, `path_prams`, `created_at`, `updated_at`, `get_prams`, `post_prams`, `request_data`, `response_data`) VALUES
(1, 0, '对外接口授权', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(2, 1, '授权登录', 1, 0, 'POST', 'open/auth/login', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"access_key\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"授权账号\"},{\"name\":\"secret_key\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"授权秘钥\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"token\",\"form_type\":\"string\",\"message\":\"授权凭证\"},{\"name\":\"token_type\",\"form_type\":\"string\",\"message\":\"凭证类型\"},{\"name\":\"expires_in\",\"form_type\":\"int\",\"message\":\"过期时间\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(3, 0, '客户基本信息', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(4, 3, '新增客户', 1, 0, 'POST', 'open/customer', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"customer_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户名称1\"},{\"name\":\"customer_label\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"客户标签\"},{\"name\":\"customer_way\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户来源\"},{\"name\":\"b37a3f16\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"企业电话\"},{\"name\":\"area_cascade\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"省市区\"},{\"name\":\"9bfe77e4\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"详细地址\"},{\"name\":\"customer_status\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户状态\"},{\"name\":\"customer_followed\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"是否关注\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(5, 3, '修改客户', 1, 0, 'PUT', 'open/customer/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"customer_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户名称1\"},{\"name\":\"customer_label\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"客户标签\"},{\"name\":\"customer_way\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户来源\"},{\"name\":\"b37a3f16\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"企业电话\"},{\"name\":\"area_cascade\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"省市区\"},{\"name\":\"9bfe77e4\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"详细地址\"},{\"name\":\"customer_status\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户状态\"},{\"name\":\"customer_followed\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"是否关注\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(6, 3, '删除客户', 1, 0, 'DELETE', 'open/customer/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(7, 0, '合同', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(8, 7, '新增合同', 1, 0, 'POST', 'open/contract', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"contract_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同名称\"},{\"name\":\"contract_no\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同编号\"},{\"name\":\"contract_status\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同状态\"},{\"name\":\"contract_followed\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"是否关注\"},{\"name\":\"contract_category\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同分类\"},{\"name\":\"contract_price\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同金额(元)\"},{\"name\":\"contract_customer\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户名称\"},{\"name\":\"start_date\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"开始时间\"},{\"name\":\"end_date\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"结束时间\"},{\"name\":\"b3733f36\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\"},{\"name\":\"signing_status\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"签约状态\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(9, 7, '修改合同', 1, 0, 'PUT', 'open/contract/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"contract_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同名称\"},{\"name\":\"contract_no\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同编号\"},{\"name\":\"contract_status\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同状态\"},{\"name\":\"contract_followed\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"是否关注\"},{\"name\":\"contract_category\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同分类\"},{\"name\":\"contract_price\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"合同金额(元)\"},{\"name\":\"contract_customer\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"客户名称\"},{\"name\":\"start_date\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"开始时间\"},{\"name\":\"end_date\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"结束时间\"},{\"name\":\"b3733f36\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\"},{\"name\":\"signing_status\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"签约状态\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(10, 7, '删除合同', 1, 0, 'DELETE', 'open/contract/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(11, 0, '客户联系人', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(12, 11, '新增联系人', 1, 0, 'POST', 'open/liaison', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"liaison_job\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人职位\"},{\"name\":\"liaison_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人姓名\"},{\"name\":\"liaison_tel\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系电话\"},{\"name\":\"e06d7153\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"性别\"},{\"name\":\"e06d7152\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人邮箱\"},{\"name\":\"e06d7159\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人微信\"},{\"name\":\"l753bf282\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\"},{\"name\":\"cdc4d06a\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人QQ\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(13, 11, '修改联系人', 1, 0, 'PUT', 'open/liaison/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"liaison_job\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人职位\"},{\"name\":\"liaison_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人姓名\"},{\"name\":\"liaison_tel\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系电话\"},{\"name\":\"e06d7153\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"性别\"},{\"name\":\"e06d7152\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人邮箱\"},{\"name\":\"e06d7159\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人微信\"},{\"name\":\"l753bf282\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\"},{\"name\":\"cdc4d06a\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人QQ\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(14, 11, '删除联系人', 1, 0, 'DELETE', 'open/liaison/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(15, 0, '发票记录', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(16, 15, '新增发票', 1, 0, 'POST', 'open/invoice', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"uid\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"关联业务员id\"},{\"name\":\"bill_id\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"关联付款单id\",\"symbol\":\"billId\"},{\"name\":\"eid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联客戶id\",\"symbol\":\"customerList\"},{\"name\":\"cid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联合同id\",\"symbol\":\"contractList\"},{\"name\":\"bill_date\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"期望开票日期\",\"symbol\":\"desireDate\"},{\"name\":\"collect_type\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"开票要求\",\"symbol\":\"invoicingMethod\"},{\"name\":\"collect_name\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系人\",\"symbol\":\"liaisonMan\"},{\"name\":\"collect_tel\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"联系电话\",\"symbol\":\"telephone\"},{\"name\":\"collect_email\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"邮箱地址\",\"symbol\":\"invoicingEmail\"},{\"name\":\"mail_address\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"邮寄地址\",\"symbol\":\"mailingAddress\"},{\"name\":\"types\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"发票类型\",\"symbol\":\"invoiceType\"},{\"name\":\"amount\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"开票金额（元）\",\"symbol\":\"invoiceAmount\"},{\"name\":\"price\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"付款单金额（元）\",\"symbol\":\"billAmount\"},{\"name\":\"title\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"发票抬头\",\"symbol\":\"invoiceHeader\"},{\"name\":\"ident\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"纳税人识别号\",\"symbol\":\"dutyParagraph\"},{\"name\":\"mark\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\",\"symbol\":\"remark\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(17, 15, '发票作废', 1, 0, 'PUT', 'open/invoice/{id}/invalid', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"uid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"业务员id\"},{\"name\":\"remark\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"作废原因\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(18, 0, '客户账目记录', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(19, 18, '新增账目回款', 1, 0, 'POST', 'open/bill/payment', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"uid\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"关联业务员id\"},{\"name\":\"cid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联合同id\",\"symbol\":\"contractList\"},{\"name\":\"bill_cate_id\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"财务收入科目id\",\"symbol\":\"incomeCategories\"},{\"name\":\"type_id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"支付方式id\",\"symbol\":\"payType\"},{\"name\":\"num\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"回款金额（元）\",\"symbol\":\"collectionAmount\"},{\"name\":\"date\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"付款时间\",\"symbol\":\"payTime\"},{\"name\":\"attach\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"付款凭证id\",\"symbol\":\"paymentVoucher\"},{\"name\":\"mark\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\",\"symbol\":\"remark\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(20, 18, '新增账目续费', 1, 0, 'POST', 'open/bill/renewal', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"uid\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"关联业务员id\"},{\"name\":\"cid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联合同id\",\"symbol\":\"contractList\"},{\"name\":\"bill_cate_id\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"财务收入科目id\",\"symbol\":\"incomeCategories\"},{\"name\":\"cate_id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"续费类型id\",\"symbol\":\"renewalType\"},{\"name\":\"type_id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"支付方式id\",\"symbol\":\"payType\"},{\"name\":\"num\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"续费金额（元）\",\"symbol\":\"renewalAmount\"},{\"name\":\"date\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"付款时间\",\"symbol\":\"payTime\"},{\"name\":\"end_date\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"续费结束日期\",\"symbol\":\"renewalEndTime\"},{\"name\":\"attach\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"付款凭证id\",\"symbol\":\"paymentVoucher\"},{\"name\":\"mark\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\",\"symbol\":\"remark\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(21, 18, '新增账目支出', 1, 0, 'POST', 'open/bill/expend', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"uid\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"关联业务员id\"},{\"name\":\"cid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联合同id\",\"symbol\":\"contractList\"},{\"name\":\"bill_cate_id\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"财务支出科目id\",\"symbol\":\"expenditureCategories\"},{\"name\":\"type_id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"支付方式id\",\"symbol\":\"payType\"},{\"name\":\"num\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"支出金额（元）\",\"symbol\":\"expenditureAmount\"},{\"name\":\"date\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"付款时间\",\"symbol\":\"payTime\"},{\"name\":\"attach\",\"form_type\":\"array\",\"is_must\":false,\"message\":\"付款凭证id\",\"symbol\":\"paymentVoucher\"},{\"name\":\"mark\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"备注\",\"symbol\":\"remark\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(22, 18, '删除账目', 1, 0, 'DELETE', 'open/bill/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(23, 18, '新增付款提醒', 1, 0, 'POST', 'open/bill/remind', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"types\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"提醒类型\"},{\"name\":\"eid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联客户id\"},{\"name\":\"cid\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"关联合同id\"},{\"name\":\"num\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"金额(元)\"},{\"name\":\"time\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"提醒日期\"},{\"name\":\"mark\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"提醒内容\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(24, 0, '日程待办', 0, 0, '0', '0', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, NULL, NULL, NULL),
(25, 24, '新增日程', 1, 0, 'POST', 'open/schedule', '', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"uid\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"关联业务员id\"},{\"name\":\"title\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"待办标题\"},{\"name\":\"member\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"参与人id\"},{\"name\":\"start_time\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"开始时间\"},{\"name\":\"end_time\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"结束时间\"},{\"name\":\"all_day\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"是否全天\"},{\"name\":\"period\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"重复周期\"},{\"name\":\"days\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"重复周期为周\\/月时的重复频率\"},{\"name\":\"rate\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"重复频率\"},{\"name\":\"remind\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"是否提醒\"},{\"name\":\"type\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"操作方式\"},{\"name\":\"fail_time\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"重复截至日期\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\",\"children\":[{\"name\":\"id\",\"form_type\":\"int\",\"message\":\"自增ID\"}]},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(26, 24, '修改日程', 1, 0, 'PUT', 'open/schedule/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"title\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"待办标题\"},{\"name\":\"member\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"参与人id\"},{\"name\":\"start_time\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"开始时间\"},{\"name\":\"end_time\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"结束时间\"},{\"name\":\"start\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"开始时间\"},{\"name\":\"end\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"结束时间\"},{\"name\":\"all_day\",\"form_type\":\"int\",\"is_must\":false,\"message\":\"是否全天\"},{\"name\":\"period\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"重复周期\"},{\"name\":\"days\",\"form_type\":\"array\",\"is_must\":true,\"message\":\"重复周期为周\\/月时的重复频率\"},{\"name\":\"rate\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"重复频率\"},{\"name\":\"remind\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"是否提醒\"},{\"name\":\"type\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"操作方式\"},{\"name\":\"fail_time\",\"form_type\":\"string\",\"is_must\":false,\"message\":\"重复截至日期\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]'),
(27, 24, '删除日程', 1, 0, 'DELETE', 'open/schedule/{id}', '[{\"name\":\"id\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"自增ID\"}]', '2024-11-06 09:41:26', '2024-11-06 09:41:26', NULL, '[{\"name\":\"start\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"开始时间\"},{\"name\":\"end\",\"form_type\":\"string\",\"is_must\":true,\"message\":\"结束时间\"},{\"name\":\"type\",\"form_type\":\"int\",\"is_must\":true,\"message\":\"操作方式\"}]', NULL, '[{\"name\":\"data\",\"form_type\":\"array\",\"message\":\"数据\"},{\"name\":\"status\",\"form_type\":\"int\",\"message\":\"状态\"},{\"name\":\"message\",\"form_type\":\"string\",\"message\":\"说明\"}]');
