/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import cn.myapps.common.data.DataPackage;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.commands.RefreshAppCommand;
import com.bcxin.runtime.domain.metas.commands.RefreshTaskCommand;
import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import com.bcxin.runtime.domain.metas.entities.enums.StartupType;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.services.ApplicationMetaService;
import com.bcxin.runtime.domain.metas.services.TaskMetaService;
import com.bcxin.runtime.domain.snapshoots.JdbcConnectionSnapshot;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.bcxin.sync.apis.responses.AppMetaResponse;
import com.bcxin.sync.apis.responses.DataSourceMetaResponse;
import com.bcxin.sync.apis.responses.FormMetaResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.bcxin.sync.apis.controllers.MetaController")
@RequestMapping(value={"/v2/sync/metas"})
public class MetaController {
    private final ApplicationMetaRepository applicationMetaRepository;
    private final ApplicationMetaService applicationMetaService;
    private final JsonProvider jsonProvider;
    private final TaskMetaService taskMetaService;

    public MetaController(ApplicationMetaRepository applicationMetaRepository, ApplicationMetaService applicationMetaService, JsonProvider jsonProvider, TaskMetaService taskMetaService) {
        this.applicationMetaRepository = applicationMetaRepository;
        this.applicationMetaService = applicationMetaService;
        this.jsonProvider = jsonProvider;
        this.taskMetaService = taskMetaService;
    }

    @PostMapping(value={"/refresh"})
    public ResponseEntity refreshMetas() throws Exception {
        this.refreshApp("");
        return this.getMetas();
    }

    @PostMapping(value={"/apps/{appName}/refresh"})
    public ResponseEntity refreshAppNameMetas(String appName) throws Exception {
        this.refreshApp(appName);
        return this.getMetas();
    }

    @PostMapping(value={"/tasks/refresh"})
    public ResponseEntity refreshTasks() throws Exception {
        Collection<RefreshTaskCommand.Task> tasks = this.buildTasks();
        RefreshTaskCommand taskCommand = RefreshTaskCommand.create(tasks);
        this.taskMetaService.refresh(taskCommand);
        return ResponseEntity.ok((Object)"\u5b8c\u6210\u4efb\u52a1\u7684\u5237\u65b0");
    }

    @GetMapping
    public ResponseEntity getMetas() {
        List metaEntities = this.applicationMetaRepository.findAll();
        Collection appMetaResponses = metaEntities.stream().map(app -> {
            ArrayList<FormMetaResponse> formMetaResponses = new ArrayList();
            if (app.getFormMetas() != null) {
                formMetaResponses = app.getFormMetas().stream().map(fm -> new FormMetaResponse(fm.getId(), fm.getFormId(), fm.getName(), fm.getTableName())).collect(Collectors.toList());
            }
            ArrayList<DataSourceMetaResponse> dataSourceMetaResponses = new ArrayList();
            if (app.getDataSourceMetas() != null) {
                dataSourceMetaResponses = app.getDataSourceMetas().stream().map(ds -> new DataSourceMetaResponse(ds.getId(), ds.getDataSourceId(), ds.getName(), ds.getUseType(), ds.getConfig(), ds.getDbType(), ds.getIsSelected() == BooleanStatus.TRUE)).collect(Collectors.toList());
            }
            AppMetaResponse metaResponse = new AppMetaResponse(app.getId(), app.getAppId(), app.getName(), app.getIsOnline() == BooleanStatus.TRUE, app.getNote());
            metaResponse.setFormMetaResponses(formMetaResponses);
            metaResponse.setDataSourceMetaResponses(dataSourceMetaResponses);
            return metaResponse;
        }).collect(Collectors.toList());
        return ResponseEntity.ok((Object)appMetaResponses);
    }

    private void refreshApp(String appName) throws Exception {
        Collection<RefreshAppCommand.Application> commandApps = this.buildApps(appName);
        this.applicationMetaService.refresh(RefreshAppCommand.create(commandApps));
    }

    private Collection<RefreshAppCommand.Application> buildApps(String name) throws Exception {
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        DataPackage applicationDataPackages = appService.query("", "", 1, Integer.MAX_VALUE);
        DataSourceDesignTimeService dataSourceService = DesignTimeServiceManager.dataSourceDesignTimeService();
        DataPackage dataSourceDataPackages = dataSourceService.query(null, null, 1, Integer.MAX_VALUE);
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        DataPackage formDataPackages = formService.query(null, null, 1, Integer.MAX_VALUE);
        Collection applications = applicationDataPackages.datas.stream().map(ii -> {
            boolean isMatched;
            boolean bl = isMatched = !StringUtils.hasLength((String)name) || ii.getName().toLowerCase(Locale.ROOT).contains(name);
            if (!isMatched) {
                return null;
            }
            RefreshAppCommand.Application app = RefreshAppCommand.Application.create((String)ii.getId(), (String)ii.getName(), (boolean)true, (String)ii.getDescription());
            if (dataSourceDataPackages != null) {
                Collection selectedDataSources = dataSourceDataPackages.datas.stream().filter(ds -> StringUtils.hasLength((String)ds.getApplicationid()) && ds.getApplicationid().equals(ii.getId()) || StringUtils.hasLength((String)ds.getParentId()) && ds.getParentId().equals(ii.getId())).map(ds -> {
                    JdbcConnectionSnapshot snapshot = JdbcConnectionSnapshot.create((String)ds.getDriverClass(), (String)ds.getUrl(), (String)ds.getUsername(), (String)ds.getPassword(), (String)ds.getPoolsize(), (String)ds.getPathSuffix(), (String)ds.getPath(), (String)ds.getUrlPkgPrefixes(), (String)ds.getTimeout());
                    String config = this.jsonProvider.getJson((Object)snapshot);
                    return RefreshAppCommand.DataSource.create((String)ds.getId(), (String)ds.getName(), (String)ds.getUseType(), (int)ds.getDbType(), (String)ds.getDriverClass(), (String)config, (boolean)ds.getId().equals(ii.getDatasourceId()));
                }).collect(Collectors.toList());
                app.setDataSources(selectedDataSources);
            }
            if (formDataPackages != null) {
                Collection selectedForms = formDataPackages.datas.stream().filter(fm -> StringUtils.hasLength((String)fm.getApplicationid()) && fm.getApplicationid().equals(ii.getId()) || StringUtils.hasLength((String)fm.getParentId()) && fm.getParentId().equals(ii.getId())).map(fm -> RefreshAppCommand.Form.create((String)fm.getId(), (String)fm.getName(), (String)fm.getTableMapping().getTableName(), (FormType)this.translate2FormType(fm.getType()))).collect(Collectors.toList());
                app.setForms(selectedForms);
            }
            return app;
        }).filter(ii -> ii != null).collect(Collectors.toList());
        return applications;
    }

    private Collection<RefreshTaskCommand.Task> buildTasks() throws Exception {
        TaskDesignTimeService taskService = DesignTimeServiceManager.taskDesignTimeService();
        DataPackage taskDataPackage = taskService.query(null, null, 0, Integer.MAX_VALUE);
        return taskDataPackage.getDatas().stream().map(tk -> {
            RefreshTaskCommand.TaskScriptConfig config = RefreshTaskCommand.TaskScriptConfig.create((StartupType)StartupType.ValueOf((int)tk.getStartupType()), (int)tk.getPeriod(), (String)tk.getTerminateScript(), (String)tk.getTaskScript());
            RefreshTaskCommand.Task task = RefreshTaskCommand.Task.create((String)tk.getApplicationid(), (String)tk.getId(), (String)tk.getName(), (String)tk.getDescription(), (String)tk.getPath(), (RefreshTaskCommand.TaskScriptConfig)config);
            return task;
        }).collect(Collectors.toList());
    }

    private FormType translate2FormType(int formType) {
        switch (formType) {
            case 1: {
                return FormType.NORMAL;
            }
            case 2: {
                return FormType.FRAGMENT;
            }
            case 4096: {
                return FormType.HOMEPAGE;
            }
            case 65536: {
                return FormType.MAPPING;
            }
            case 16: {
                return FormType.SUBFORM;
            }
            case 256: {
                return FormType.SEARCHFORM;
            }
            case 0x100000: {
                return FormType.TEMPLATEFORM;
            }
        }
        throw new SaasNoSupportException(String.format("\u4e0d\u652f\u6301\u7684FormType(%s)", String.valueOf(formType)));
    }
}

