/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.util.ftp.FtpUtils;
import com.bcxin.saas.core.AppConfigProperty;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.configs.FileModeConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/sync/file/download"})
public class FileDownloadController {
    private final AppConfigProperty appConfigProperty;
    private static final Logger logger = LoggerFactory.getLogger(FileDownloadController.class);

    public FileDownloadController(AppConfigProperty appConfigProperty) {
        this.appConfigProperty = appConfigProperty;
    }

    @GetMapping
    public void download(@RequestParam(value="f") String path, HttpServletResponse response) {
        block45: {
            if (!StringUtils.hasLength((String)path)) {
                this.response(response, HttpStatus.NOT_FOUND, "\u8981\u4e0b\u8f7d\u7684\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            try {
                if (FileModeConfig.getUseFtp().booleanValue() && path.indexOf("/uploads/lib/icon/") < 0) {
                    InputStream is = null;
                    ServletOutputStream out = null;
                    File tempFile = null;
                    try {
                        String filePath = path.substring(0, path.lastIndexOf("/") + 1);
                        String fileName = path.substring(path.lastIndexOf("/") + 1);
                        String tempPath = PropertyUtil.getPath() + "/temp/";
                        tempFile = FtpUtils.downloadFile((String)FileModeConfig.getHost(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword(), (int)FileModeConfig.getPort(), (String)((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath), (String)tempPath, (String)fileName);
                        is = new FileInputStream(tempFile);
                        out = response.getOutputStream();
                        fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                        int read = 0;
                        byte[] buffer = new byte[8192];
                        while ((read = is.read(buffer)) != -1) {
                            out.write(buffer, 0, read);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw new SaasNofoundException("\u6587\u4ef6" + path + "\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            throw new SaasNofoundException("\u6587\u4ef6" + path + "\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                        }
                    }
                    tempFile.delete();
                    break block45;
                }
                try (InputStream inputStream = this.getInputStream(path);){
                    byte[] temp = new byte[2048];
                    response.setContentType("application/octet-stream");
                    response.setContentType("application/x-msdownload");
                    String attachmentFileName = String.format("attachment; filename=%s", URLEncoder.encode(FileUtil.getName((String)path), "UTF-8"));
                    response.setHeader("Content-Disposition", attachmentFileName);
                    try (ServletOutputStream stream = response.getOutputStream();){
                        int len = 0;
                        while ((len = inputStream.read(temp)) != -1) {
                            stream.write(temp, 0, len);
                        }
                        stream.flush();
                    }
                }
                catch (FileNotFoundException e) {
                    this.response(response, HttpStatus.NOT_FOUND, ExceptionUtils.getStackMessage((Throwable)e));
                    e.printStackTrace();
                }
                catch (IOException ex) {
                    this.response(response, HttpStatus.BAD_REQUEST, ExceptionUtils.getStackMessage((Throwable)ex));
                    ex.printStackTrace();
                }
            }
            catch (SaasNofoundException ex) {
                this.response(response, HttpStatus.NOT_FOUND, String.format("\u6587\u4ef6\u4e0d\u5b58\u5728(%s)\u6216\u8005\u65e0\u6548", path));
            }
        }
    }

    private void response(HttpServletResponse response, HttpStatus status, String msg) {
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(msg);
        }
        catch (Exception ex) {
            logger.error("FileDownloadController.response \u5f02\u5e38", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private InputStream getInputStream(String path) throws FileNotFoundException {
        if (path.startsWith("http")) {
            return HttpUtil.createGet((String)path).execute().bodyStream();
        }
        String sysPath = PropertyUtil.getPath();
        File file = new File(sysPath + path);
        if (!file.exists() || !file.canRead()) {
            throw new SaasNofoundException("\u627e\u4e0d\u5230\u6587\u4ef6");
        }
        return new FileInputStream(file);
    }
}

