/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import cn.hutool.core.util.StrUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.util.ftp.FtpUtils;
import com.bcxin.sync.apis.configs.FileModeConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/runtime"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    private Logger logger = LoggerFactory.getLogger(FileController.class);

    public static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static boolean StringFilter(String str) throws PatternSyntaxException {
        Pattern p;
        Matcher m;
        boolean resulst = true;
        String regEx = "[ `~!@#$%^&*()+=|{}':;',\\[\\]<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
        if (str.indexOf("..") > 0) {
            resulst = false;
        }
        if ((m = (p = Pattern.compile(regEx)).matcher(str)).find()) {
            resulst = false;
        }
        return resulst;
    }

    public static boolean timeStampDate(String seconds) {
        boolean convertSuccess = true;
        try {
            if (seconds == null || seconds.isEmpty() || seconds.equals("null")) {
                return false;
            }
            String format = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.format(new Date(Long.valueOf(seconds + "000")));
        }
        catch (Exception e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getResource"})
    public void getResource(String path, HttpServletResponse response) throws Exception {
        File file = null;
        InputStream is = null;
        ServletOutputStream out = null;
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        String fileTypes = "ZIP,RAR";
        if (FileModeConfig.getUseFtp().booleanValue() && path.startsWith("upload")) {
            String[] paths = path.split("/");
            if (paths.length != 3) {
                throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
            }
            try {
                String filePath = path.substring(0, path.lastIndexOf("/") + 1);
                String fileName = path.substring(path.lastIndexOf("/") + 1);
                String tempPath = PropertyUtil.getPath() + "/temp/";
                File tempFile = FtpUtils.downloadFile((String)FileModeConfig.getHost(), (String)FileModeConfig.getUserName(), (String)FileModeConfig.getPassword(), (int)FileModeConfig.getPort(), (String)((StrUtil.isEmpty((CharSequence)FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath), (String)tempPath, (String)fileName);
                is = new FileInputStream(tempFile);
                out = response.getOutputStream();
                fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                tempFile.delete();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new Exception("\u6587\u4ef6" + path + "\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        if (path.startsWith("upload")) {
            file = new File(PropertyUtil.getPath() + path);
        } else if (path.startsWith("temp")) {
            file = new File(PropertyUtil.getPath() + path);
        } else if (path.startsWith("pdf")) {
            file = new File(PropertyUtil.getPath() + path);
        } else if (path.startsWith("sysAttachment")) {
            file = new File(PropertyUtil.getPath() + path);
        } else if (path.startsWith("approveAttachment")) {
            file = new File(PropertyUtil.getPath() + path);
        } else if (path.startsWith("personImg")) {
            file = new File(PropertyUtil.getPath() + path);
        } else {
            throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
        }
        this.logger.info("\u6587\u4ef6\u8def\u5f84\uff1a " + file.getPath());
        String[] paths = path.split("/");
        if (paths.length != 3) {
            throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
        }
        if (!FileController.isValidDate(paths[1])) {
            throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
        }
        String fileType = paths[2];
        String[] temp = fileType.split("\\.");
        if (temp.length != 2) {
            throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
        }
        if (!FileController.StringFilter(fileType)) {
            throw new Exception("\u7cfb\u7edf\u9519\u8bef\uff01\uff01\uff01");
        }
        if (file != null) {
            try {
                out = response.getOutputStream();
                String fileName = new String(file.getName().getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
    }
}

