package com.bcxin.security.api.impls;

import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.security.AttendSiteRpcProvider;
import com.bcxin.api.interfaces.security.responses.AttendSiteResponse;
import com.bcxin.security.domains.entities.AttendSiteEntity;
import com.bcxin.security.domains.repositories.AttendSiteRepository;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author linqinglin
 * @date 2021/12/11 0011 15:21
 */

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class AttendSiteRpcProviderImpl implements AttendSiteRpcProvider {

    public static Logger logger = LoggerFactory.getLogger(AttendSiteRpcProviderImpl.class);

    private final AttendSiteRepository attendSiteRepository;

    public AttendSiteRpcProviderImpl(AttendSiteRepository attendSiteRepository){
        this.attendSiteRepository = attendSiteRepository;
    }

    @Override
    public List<AttendSiteResponse> list(String orgId) {
        Collection<AttendSiteEntity> list = attendSiteRepository.list(orgId);

        if(list.size() > 0) {
            List<AttendSiteResponse> responses = new ArrayList<>();
            for (AttendSiteEntity attendSiteEntity : list) {
                responses.add(AttendSiteResponse.create(attendSiteEntity.getId(),attendSiteEntity.getAttendSiteName()));
            }
            return responses;
        }
        return null;
    }
}
