package com.bcxin.security.api;

import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.registration.nacos.NacosDataSourceConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(NacosDataSourceConfig.class)
@Configuration
@EnableDubbo(scanBasePackages = "com.bcxin.security.api.impls")
@ComponentScan({
        "com.bcxin.api.interfaces.tenants",
        "com.bcxin.security.domains.configs",
        "com.bcxin.security.domain.repositories"})
@Import(InitConfig.class)
public class SecurityConfiguration {

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final UserRpcProvider userRpcProvider;

    public SecurityConfiguration(UserRpcProvider userRpcProvider) {
        this.userRpcProvider = userRpcProvider;
    }
}
