package com.bcxin.api.interfaces.tenants.requests.tenantUsers;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Data
public class TenantUserExtensionListRequest implements Serializable {

    @ApiModelProperty(value = "拓展信息列表")
    private List<TenantUserExtensionRequest> extensionList;

    @ApiModelProperty(value = "拓展信息对象")
    private Map<String, String> extensionMap;


    public List<TenantUserExtensionRequest> getExtensionList() {
        if (CollectionUtil.isEmpty(extensionList) && CollectionUtil.isEmpty(extensionMap)) {
            throw new ArgumentTenantException("拓展信息不能为空");
        }
        if (CollectionUtil.isEmpty(extensionList)) {
            extensionList = new ArrayList<>();
            for (Map.Entry<String, String> entry : extensionMap.entrySet()) {
                TenantUserExtensionRequest extensionRequest = new TenantUserExtensionRequest();
                extensionRequest.setExtensionKey(entry.getKey());
                extensionRequest.setExtensionValue(entry.getValue());
                extensionList.add(extensionRequest);
            }
        }
        return extensionList;
    }
}
