package com.bcxin.api.interfaces.tenants.requests.organizationType;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@ApiModel("添加集团组织类型请求对象")
@Data
public class OrganizationTypeCreateRequest extends RequestAbstract {


    @ApiModelProperty(value = "集团组织类型名称", required = true)
    @NotBlank(message = "集团组织类型名称不能为空")
    private String name;

    @ApiModelProperty(value = "集团组织类型备注")
    private String note;

    @ApiModelProperty(value = "所属组织", required = true)
    @NotBlank(message = "所属组织不能为空")
    private String organizationId;

}
