package com.bcxin.api.interfaces.tenants.requests.employees;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.PersonStatus;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Date;

@Data
public class ChangeEmployeeOccupationTypeRequest extends RequestAbstract {
    /**
     * 员工id
     */
    @ApiModelProperty(value = "员工id")
    private String employeeId;
    /**
     * 职业: 保安员, 其他
     */
    @Enumerated(EnumType.ORDINAL)
    private OccupationType occupationType;
}
