package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationAdminCriteria;
import com.bcxin.api.interfaces.tenants.requests.orgainzaitionAdmins.CreateOrganizationAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.orgainzaitionAdmins.DeleteOrganizationAdminRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationAdminResponse;
import org.springframework.stereotype.Component;

@Component
public interface OrganizationAdminRpcProvider {
    void create(String organizationId, CreateOrganizationAdminRequest request);

    void delete(String organizationId, DeleteOrganizationAdminRequest request);

    Pageable<OrganizationAdminResponse> search(String organizationId, OrganizationAdminCriteria criteria);
}
