package com.bcxin.api.interfaces.rbacs.custom.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("自定义角色新增对象")
@Data
public class RbacCustomRoleAddRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "复制角色的id(复制角色的时候传)")
    private Long sourceId;

    @ApiModelProperty(value = "企业id", hidden = true)
    private String organizationId;

    @ApiModelProperty(value = "角色名称", required = true)
    @NotBlank(message = "角色名称不能为空")
    private String roleName;

    @ApiModelProperty(value = "备注说明")
    private String remark;

    @ApiModelProperty(value = "排序")
    @NotNull(message = "排序不能为空")
    private Integer seq;

}
