package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Timestamp;

@Schema(name = "TenantAccountSettingResponse",title = "TenantAccountSettingResponse 返回当前主体的设置信息")
@Data
public class TenantAccountSettingResponse extends ResponseAbstract {

    @Schema(name = "sosEnabled", title = "是否启用Sos设置")
    private boolean sosEnabled;

    @Schema(name = "sosKey", title = "Sos的热键")
    private String sosKey;

    @Schema(name = "logo", title = "图标: 一般指调度台的图标")
    private String logo;

    @Schema(name = "title", title = "标题: 一般指调度台的标题")
    private String title;

    @Schema(name = "readInstructionTime", title = "阅读APP操作指令的时间")
    private Timestamp readInstructionTime;

    @Schema(name = "hasReadInstruction", title = "是否已阅读App的视频操作指令")
    private boolean hasReadInstruction;

    @Schema(name = "alarmBell", title = "警报铃声")
    private String alarmBell;

    public TenantAccountSettingResponse(){}

    public TenantAccountSettingResponse(boolean sosEnabled, String sosKey, String logo, String title,
                                        Timestamp readInstructionTime,
                                        String alarmBell) {
        this.sosEnabled = sosEnabled;
        this.sosKey = sosKey;
        this.logo = logo;
        this.title = title;
        this.readInstructionTime = readInstructionTime;
        this.hasReadInstruction = readInstructionTime == null ? false : true;
        this.alarmBell = alarmBell;
    }

    public static TenantAccountSettingResponse create(boolean sosEnabled, String sosKey, String logo, String title,
                                                      Timestamp readInstructionTime,
                                                      String alarmBell) {
        return new TenantAccountSettingResponse(sosEnabled, sosKey, logo, title,readInstructionTime,alarmBell);
    }
}
