package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.NotifyMessageType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "NotifyMessageResponse",title = "即时消息")
@Getter
public class NotifyMessageResponse extends ResponseAbstract {
    @Schema(name = "id", title = "消息Id")
    private final String id;
    @Schema(name = "messageType", title = "消息类型: 分为Dispatch=调度/督导;RollCall=点名")
    private final NotifyMessageType type;
    @Schema(name = "content", title = "消息内容; 不同类型的消息内容不一样;")
    private final Object content;

    public NotifyMessageResponse(String id,NotifyMessageType messageType, Object content) {
        this.id = id;
        this.content = content;
        this.type = messageType;
    }

    public static NotifyMessageResponse create(String id,NotifyMessageType messageType, Object content) {
        return new NotifyMessageResponse(id, messageType,  content);
    }
}
