package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "CreateRoomWriterRpcRequest",title = "CreateRoomWriterRpcRequest 调度前的联动值验证及开放房间")
@Data
public class CreateRoomWriterRpcRequest extends RequestAbstract {
    @Schema(name = "roomUsers", title = "加入房间的人员")
    private Collection<RoomUserRequest> roomUsers;

    @Schema(name = "communicatedType", title = "communicatedType 沟通方式: Audio 音频;Video 视频")
    private CommunicatedType communicatedType;

    @Schema(name = "yardmanType", title = "1; 音视频调度, 2 视频上拉")
    private int yardmanType;

    /**
     * 引用的调度类型
     */
    @Schema(name = "referenceType", title = "Normal; 常规调度, Sos 一键报警调度； RollCall： 督导点名")
    private DispatchReasonType referenceType;

    /**
     * 引用的编码
     */
    @Schema(name = "referenceNumber", title = "引用的数据")
    private String referenceNumber;

    @Schema(name = "deskType", title = "调度台类型;Proprietor=内保调度台; Normal=正常的指挥调度台;TemporarySecurity=临保业务")
    private DeskType deskType;

    @Data
    public static class RoomUserRequest extends RequestAbstract {
        @Schema(name = "employeeId", title = "保安员的Id")
        private String employeeId;
        @Schema(name = "organizationId", title = "企业Id")
        private String organizationId;
        @Schema(name = "tencentUserId", title = "音视频Id")
        private String tencentUserId;
        @Schema(name = "securityStationId", title = "驻勤点Id")
        private String securityStationId;
        @Schema(name = "superviseDepartId", title = "监管归属Id")
        private String superviseDepartId;
        @Schema(name = "sponsor", title = "是否为调度发起人")
        private boolean isSponsor;
    }
}
