package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import com.bcxin.tenant.open.infrastructures.models.AgentHeaderOptionValue;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "AttendanceValidationRequest",title = "签到前的验证信息")
@Getter
public class AttendanceValidationRequest extends RequestAbstract {

    @Schema(name = "employeeId", title = "当前的职员信息")
    private final String employeeId;

    @Schema(name = "recordStatus", title = "状态：SignIn 签到，SignOut 签退")
    private final RecordStatus recordStatus;

    @Schema(name = "referenceType", title = "类型：Comon 普通，Station 驻勤点")
    private final ReferenceType referenceType;

    @Schema(name = "referenceNumber", title = "类型：Comon #1，Station 驻勤点Id")
    private final String referenceNumber;

    @Schema(name = "note", title = "备注")
    private final String note;

    @Schema(name = "address", title = "地址")
    private final String address;

    @Schema(name = "latitude", title = "维度 y")
    private final double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private final double longitude;

    @Schema(name = "headerOption", title = "请求头信息", hidden = true)
    private final AgentHeaderOptionValue headerOption;

    public AttendanceValidationRequest(String employeeId, RecordStatus recordStatus, ReferenceType referenceType, String referenceNumber,
                                       String note,
                                       String address, double latitude, double longitude,
                                       AgentHeaderOptionValue headerOption) {
        this.employeeId = employeeId;
        this.recordStatus = recordStatus;
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.note = note;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.headerOption = headerOption;
    }

    public static AttendanceValidationRequest create(String employeeId, RecordStatus recordStatus, ReferenceType referenceType, String referenceNumber,
                                                     String note,
                                                     String address, double latitude, double longitude,
                                                     AgentHeaderOptionValue headerOption) {
        return new AttendanceValidationRequest(employeeId, recordStatus, referenceType,referenceNumber, note, address, latitude, longitude, headerOption);
    }
}