package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Getter
public class WorkstationResponse extends ResponseAbstract {
    @Schema(name = "id", title = "当referenceType不为JobStation的时候; 此值为ReferenceNumber也就是岗点/驻勤点的Id值")
    private final String id;

    @Schema(name = "latitude", title = "所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "所在x轴坐标")
    private final Double longitude;

    @Schema(name = "displayOrder", title = "顺序")
    private final int displayOrder;

    /**
     * 显示名: 驻勤点、岗点、巡防任务-点位
     */
    @Schema(name = "name", title = "显示名: 驻勤点、岗点、巡防任务-点位")
    private final String name;

    @Schema(name = "address", title = "点位所在的地址")
    private final String address;

    @Schema(name = "performRange", title = "执行范围")
    private final Double performRange;

    @Schema(name = "referenceType", title = "点位类型: 驻勤点/岗点/点位")
    private final ReferenceType referenceType;

    @Schema(name = "referenceLineId", title = "所属线路Id")
    private final String referenceLineId;

    public WorkstationResponse(String id, Double latitude, Double longitude,
                               int displayOrder, String displayName,
                               String address, Double performRange,
                               ReferenceType referenceType,
                               String referenceLineId) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
        this.displayOrder = displayOrder;
        this.name = displayName;
        this.address = address;
        this.performRange = performRange;
        this.referenceType = referenceType;
        this.referenceLineId = referenceLineId;
    }

    public static WorkstationResponse create(String id, Double latitude, Double longitude,
                                             int displayOrder, String displayName,
                                             String address, Double performRange,
                                             ReferenceType referenceType,
                                             String referenceLineId) {
        return new WorkstationResponse(id, latitude, longitude, displayOrder, displayName, address, performRange,referenceType,referenceLineId);
    }
}
